/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.net.uniprot;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.net.uniprot.UniprotColumn;
import ch.systemsx.cisd.common.net.uniprot.UniprotEntry;
import ch.systemsx.cisd.common.net.uniprot.UniprotEntryParserFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public final class UniprotQuery {
    private static final int RETRY_COUNT = 3;
    private static final String BASE_URL = "http://www.uniprot.org/uniprot/";
    private static final String QUERY_INIT_STR = "query=";
    private static final String COLUMN_INIT_STR = "columns=";
    private static final String FORMAT_STR = "format=tab";
    private static final String OFFSET_STR = "offset=";
    private static final String LIMIT_STR = "limit=";
    private final String columnsSpecification;

    public static Set<UniprotColumn> columns(UniprotColumn ... columns) {
        EnumSet<UniprotColumn> set = EnumSet.noneOf(UniprotColumn.class);
        UniprotColumn[] uniprotColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            UniprotColumn col = uniprotColumnArray[n2];
            set.add(col);
            ++n2;
        }
        return set;
    }

    public UniprotQuery(UniprotColumn ... columns) {
        this(UniprotQuery.columns(columns));
    }

    public UniprotQuery(Set<UniprotColumn> columns) {
        columns.add(UniprotColumn.ID);
        this.columnsSpecification = this.createColumnSpecification(columns);
    }

    private String createColumnSpecification(Set<UniprotColumn> columns) {
        StringBuilder builder = new StringBuilder();
        builder.append(COLUMN_INIT_STR);
        for (UniprotColumn col : columns) {
            builder.append(col.getFieldName());
            builder.append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private String buildQueryURLForKeys(List<String> keys) {
        StringBuilder builder = new StringBuilder();
        builder.append(BASE_URL);
        builder.append('?');
        builder.append(QUERY_INIT_STR);
        for (String key : keys) {
            builder.append("accession:");
            builder.append(key);
            builder.append("+or+");
        }
        builder.setLength(builder.length() - "+or+".length());
        builder.append('&');
        builder.append(FORMAT_STR);
        builder.append('&');
        builder.append(this.columnsSpecification);
        return builder.toString();
    }

    private String buildQueryURLForQueryExpression(String queryExpression, int limit, int offset) {
        StringBuilder builder = new StringBuilder();
        builder.append(BASE_URL);
        builder.append('?');
        builder.append(QUERY_INIT_STR);
        builder.append(queryExpression.replaceAll(" ", "%20"));
        builder.append('&');
        builder.append(FORMAT_STR);
        builder.append('&');
        builder.append(this.columnsSpecification);
        if (limit > 0) {
            builder.append('&');
            builder.append(LIMIT_STR);
            builder.append(Integer.toString(limit));
        }
        if (offset > 0) {
            builder.append('&');
            builder.append(OFFSET_STR);
            builder.append(Integer.toString(offset));
        }
        return builder.toString();
    }

    private Iterable<UniprotEntry> runQuery(String queryURL) throws IOExceptionUnchecked {
        HttpClient client = new HttpClient();
        final GetMethod method = new GetMethod(queryURL);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new IOExceptionUnchecked(new IOException("GET failed: " + method.getStatusLine()));
            }
            final TabFileLoader<UniprotEntry> parser = new TabFileLoader<UniprotEntry>(new IParserObjectFactoryFactory<UniprotEntry>(){

                @Override
                public IParserObjectFactory<UniprotEntry> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                    return new UniprotEntryParserFactory(propertyMapper);
                }
            });
            return new Iterable<UniprotEntry>(){
                boolean hasIterated = false;

                @Override
                public Iterator<UniprotEntry> iterator() {
                    try {
                        if (this.hasIterated) {
                            throw new IllegalStateException();
                        }
                        this.hasIterated = true;
                        return new Iterator<UniprotEntry>(parser){
                            Map<String, String> defauts = Collections.emptyMap();
                            final Iterator<UniprotEntry> delegate;
                            {
                                this.delegate = tabFileLoader.iterate(getMethod.getResponseBodyAsStream(), this.defauts);
                            }

                            @Override
                            public boolean hasNext() {
                                boolean hasNext = this.delegate.hasNext();
                                if (!hasNext) {
                                    method.releaseConnection();
                                }
                                return hasNext;
                            }

                            @Override
                            public UniprotEntry next() {
                                try {
                                    return this.delegate.next();
                                }
                                catch (RuntimeException ex) {
                                    method.releaseConnection();
                                    throw ex;
                                }
                            }

                            @Override
                            public void remove() {
                                method.releaseConnection();
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    catch (IOException ex) {
                        method.releaseConnection();
                        throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                    }
                }
            };
        }
        catch (IOException ex) {
            method.releaseConnection();
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public Iterable<UniprotEntry> queryForIds(String ... keys) throws IOExceptionUnchecked {
        return this.queryForIds(Arrays.asList(keys));
    }

    public Iterable<UniprotEntry> queryForIds(List<String> keys) throws IOExceptionUnchecked {
        String queryURL = this.buildQueryURLForKeys(keys);
        return this.runQuery(queryURL);
    }

    public Iterable<UniprotEntry> query(String queryExpression) throws IOExceptionUnchecked {
        String queryURL = this.buildQueryURLForQueryExpression(queryExpression, 0, 0);
        return this.runQuery(queryURL);
    }

    public Iterable<UniprotEntry> query(String queryExpression, int limit, int offset) throws IOExceptionUnchecked {
        String queryURL = this.buildQueryURLForQueryExpression(queryExpression, limit, offset);
        return this.runQuery(queryURL);
    }
}

