/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.TimeoutExceptionUnchecked;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.time.DateFormatThreadLocal;
import ch.systemsx.cisd.etlserver.BaseDirectoryHolder;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.FileRenamer;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IPostRegistrationAction;
import ch.systemsx.cisd.etlserver.IPreRegistrationAction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class DataSetRegistrationAlgorithm {
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataSetRegistrationAlgorithm.class);
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetRegistrationAlgorithm.class);
    public static final String EMAIL_SUBJECT_TEMPLATE = "Success: data set for experiment '%s";
    public static final String DATA_SET_REGISTRATION_FAILURE_TEMPLATE = "Registration of data set '%s' failed.";
    public static final String DATA_SET_STORAGE_FAILURE_TEMPLATE = "Storing data set '%s' failed.";
    public static final String SUCCESSFULLY_REGISTERED = "Successfully registered data set: [";
    private final DataSetRegistrationAlgorithmState state;
    private final IDataSetInApplicationServerRegistrator applicationServerRegistrator;
    private final IRollbackDelegate rollbackDelegate;
    private final File incomingDataSetFile;
    private final DataSetInformation dataSetInformation;
    private BaseDirectoryHolder baseDirectoryHolder;
    private String errorMessageTemplate;

    public DataSetRegistrationAlgorithm(DataSetRegistrationAlgorithmState state, IRollbackDelegate rollbackDelegate) {
        this(state, rollbackDelegate, new DefaultApplicationServerRegistrator(state));
    }

    public DataSetRegistrationAlgorithm(DataSetRegistrationAlgorithmState state, IRollbackDelegate rollbackDelegate, IDataSetInApplicationServerRegistrator applicationServerRegistrator) {
        this.state = state;
        this.rollbackDelegate = rollbackDelegate;
        this.incomingDataSetFile = state.incomingDataSetFile;
        this.dataSetInformation = state.dataSetInformation;
        this.errorMessageTemplate = state.defaultErrorMessageTemplate;
        this.applicationServerRegistrator = applicationServerRegistrator;
    }

    public final void prepare() {
        File baseDirectory = this.createBaseDirectory(this.getDataStoreStrategy(), this.state.storeRoot);
        this.baseDirectoryHolder = new BaseDirectoryHolder(this.getDataStoreStrategy(), baseDirectory, this.state.incomingDataSetFile);
    }

    public boolean hasDataSetBeenIdentified() {
        return this.state.dataStoreStrategy.getKey() == DataStoreStrategyKey.IDENTIFIED;
    }

    public final List<DataSetInformation> registerDataSet() {
        String processorID = this.getTypeExtractor().getProcessorType(this.incomingDataSetFile);
        try {
            this.getDataSetValidator().assertValidDataSet(this.state.dataSetType, this.incomingDataSetFile);
            this.registerDataSetAndInitiateProcessing(processorID);
            this.logAndNotifySuccessfulRegistration(this.getEmail());
            if (this.state.fileOperations.exists(this.incomingDataSetFile) && !this.removeAndLog("clean up failed")) {
                this.getOperationLog().error("Cannot delete '" + this.incomingDataSetFile.getAbsolutePath() + "'.");
            }
            this.clean();
            return Collections.singletonList(this.dataSetInformation);
        }
        catch (HighLevelException ex) {
            String userEmailOrNull = this.dataSetInformation.tryGetUploadingUserEmail();
            boolean deleted = false;
            if (userEmailOrNull != null) {
                String errorMessage = "Error when trying to register data set '" + this.incomingDataSetFile.getName() + "'.";
                this.state.mailClient.sendMessage(String.format(errorMessage, this.dataSetInformation.getExperimentIdentifier().getExperimentCode()), ex.getMessage(), null, null, userEmailOrNull);
                if (this.state.shouldDeleteUnidentified) {
                    deleted = this.removeAndLog(String.valueOf(errorMessage) + " [" + ex.getMessage() + "]");
                }
            }
            if (!deleted) {
                this.rollback(ex);
            }
            return Collections.emptyList();
        }
        catch (Throwable throwable) {
            this.rollback(throwable);
            return Collections.emptyList();
        }
    }

    public final void dealWithUnidentifiedDataSet() {
        boolean ok;
        boolean bl = ok = this.state.shouldDeleteUnidentified ? this.removeAndLog(String.valueOf(this.incomingDataSetFile.getName()) + " could not be identified.") : FileRenamer.renameAndLog(this.incomingDataSetFile, this.getBaseDirectoryHolder().getTargetFile());
        if (ok) {
            this.clean();
        }
    }

    public final File createBaseDirectory(IDataStoreStrategy strategy, File baseDir) {
        File baseDirectory = strategy.getBaseDirectory(baseDir, this.dataSetInformation, this.state.dataSetType);
        baseDirectory.mkdirs();
        if (!this.state.fileOperations.isDirectory(baseDirectory)) {
            throw EnvironmentFailureException.fromTemplate("Creating data set base directory '%s' for data set '%s' failed.", baseDirectory.getAbsolutePath(), this.state.incomingDataSetFile);
        }
        return baseDirectory;
    }

    public DataSetInformation getDataSetInformation() {
        return this.dataSetInformation;
    }

    public BaseDirectoryHolder getBaseDirectoryHolder() {
        return this.baseDirectoryHolder;
    }

    public void setBaseDirectoryHolder(BaseDirectoryHolder baseDirectoryHolder) {
        this.baseDirectoryHolder = baseDirectoryHolder;
    }

    public String getErrorMessageTemplate() {
        return this.errorMessageTemplate;
    }

    public File getStoreRoot() {
        return this.state.storeRoot;
    }

    public IStorageProcessorTransactional.UnstoreDataAction rollbackStorageProcessor(Throwable throwable) {
        if (this.state.transaction == null) {
            return this.state.storageProcessor.getDefaultUnstoreDataAction(throwable);
        }
        return this.state.transaction.rollback(throwable);
    }

    protected boolean clean() {
        return (Boolean)this.state.cleanAfterwardsAction.execute(true);
    }

    private void registerDataSetInApplicationServer(NewExternalData data) throws Throwable {
        this.applicationServerRegistrator.registerDataSetInApplicationServer(data);
    }

    private void rollback(Throwable ex) {
        this.rollbackDelegate.rollback(this, ex);
    }

    private void registerDataSetAndInitiateProcessing(String procedureTypeCode) throws Throwable {
        File markerFile = this.createProcessingMarkerFile();
        try {
            String entityDescription = this.createEntityDescription();
            if (this.getOperationLog().isInfoEnabled()) {
                this.getOperationLog().info("Start storing data set for " + entityDescription + ".");
            }
            StopWatch watch = new StopWatch();
            watch.start();
            NewExternalData data = this.createExternalData();
            this.state.preRegistrationAction.execute(data.getCode(), this.incomingDataSetFile.getAbsolutePath());
            IStorageProcessorTransactional.StorageProcessorTransactionParameters transactionParameters = new IStorageProcessorTransactional.StorageProcessorTransactionParameters(this.dataSetInformation, this.incomingDataSetFile, this.baseDirectoryHolder.getBaseDirectory());
            this.state.transaction = this.getStorageProcessor().createTransaction(transactionParameters);
            this.state.transaction.storeData(this.getTypeExtractor(), this.state.mailClient, this.incomingDataSetFile);
            if (this.getOperationLog().isInfoEnabled()) {
                this.getOperationLog().info("Finished storing data set for " + entityDescription + ", took " + watch);
            }
            File dataFolder = this.state.transaction.getStoredDataDirectory();
            assert (dataFolder != null) : "The folder that contains the stored data should not be null.";
            String relativePath = FileUtilities.getRelativeFilePath(this.state.storeRoot, dataFolder);
            String absolutePath = dataFolder.getAbsolutePath();
            assert (relativePath != null) : String.format("Target path '%s' is not relative to store root directory '%s'.", absolutePath, DataSetRegistrationAlgorithmState.access$4(this.state).getAbsolutePath());
            StorageFormat availableFormat = this.getStorageProcessor().getStorageFormat();
            BooleanOrUnknown isCompleteFlag = this.dataSetInformation.getIsCompleteFlag();
            this.state.registrationLock.lock();
            try {
                this.errorMessageTemplate = DATA_SET_REGISTRATION_FAILURE_TEMPLATE;
                this.plainRegisterDataSet(data, relativePath, availableFormat, isCompleteFlag);
                this.state.postRegistrationAction.execute(data.getCode(), absolutePath);
                this.clean();
            }
            finally {
                this.state.registrationLock.unlock();
            }
            this.state.transaction.commit();
        }
        catch (Throwable throwable) {
            try {
                this.getFileOperations().delete(markerFile);
            }
            catch (TimeoutExceptionUnchecked timeoutExceptionUnchecked) {
                QueueingPathRemoverService.removeRecursively(markerFile);
            }
            throw throwable;
        }
        try {
            this.getFileOperations().delete(markerFile);
        }
        catch (TimeoutExceptionUnchecked timeoutExceptionUnchecked) {
            QueueingPathRemoverService.removeRecursively(markerFile);
        }
    }

    private NewExternalData createExternalData() {
        NewExternalData data = new NewExternalData();
        data.setUserId(this.dataSetInformation.getUploadingUserIdOrNull());
        data.setUserEMail(this.dataSetInformation.tryGetUploadingUserEmail());
        data.setExtractableData(this.dataSetInformation.getExtractableData());
        data.setShareId(this.dataSetInformation.getShareId());
        data.setSpeedHint(this.dataSetInformation.getSpeedHint());
        data.setLocatorType(this.getTypeExtractor().getLocatorType(this.incomingDataSetFile));
        data.setDataSetType(this.getTypeExtractor().getDataSetType(this.incomingDataSetFile));
        data.setFileFormatType(this.getTypeExtractor().getFileFormatType(this.incomingDataSetFile));
        data.setMeasured(this.getTypeExtractor().isMeasuredData(this.incomingDataSetFile));
        data.setDataStoreCode(this.state.dataStoreCode);
        return data;
    }

    private void logAndNotifySuccessfulRegistration(String email) {
        String msg = null;
        if (this.getOperationLog().isInfoEnabled()) {
            msg = this.getSuccessRegistrationMessage();
            this.getOperationLog().info(msg);
        }
        if (this.state.shouldNotifySuccessfulRegistration) {
            if (msg == null) {
                msg = this.getSuccessRegistrationMessage();
            }
            if (this.getNotificationLog().isInfoEnabled()) {
                this.getNotificationLog().info(msg);
            }
            if (!StringUtils.isBlank((String)email)) {
                this.state.mailClient.sendMessage(String.format(this.state.emailSubjectTemplate, this.dataSetInformation.getExperimentIdentifier().getExperimentCode()), msg, null, null, email);
            }
        }
    }

    private final String getSuccessRegistrationMessage() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SUCCESSFULLY_REGISTERED);
        String userID = this.dataSetInformation.getUploadingUserIdOrNull();
        String userEMail = this.dataSetInformation.tryGetUploadingUserEmail();
        if (userID != null || userEMail != null) {
            this.appendNameAndObject(buffer, "User", userID == null ? userEMail : userID);
        }
        this.appendNameAndObject(buffer, "Data Set Code", this.dataSetInformation.getDataSetCode());
        this.appendNameAndObject(buffer, "Data Set Type", this.state.dataSetType.getCode());
        this.appendNameAndObject(buffer, "Experiment Identifier", this.dataSetInformation.getExperimentIdentifier());
        this.appendNameAndObject(buffer, "Sample Identifier", this.dataSetInformation.getSampleIdentifier());
        this.appendNameAndObject(buffer, "Producer Code", this.dataSetInformation.getProducerCode());
        this.appendNameAndObject(buffer, "Production Date", this.formatDate(this.dataSetInformation.getProductionDate()));
        List<String> parentDataSetCodes = this.dataSetInformation.getParentDataSetCodes();
        if (!parentDataSetCodes.isEmpty()) {
            this.appendNameAndObject(buffer, "Parent Data Sets", StringUtils.join(parentDataSetCodes, (char)' '));
        }
        this.appendNameAndObject(buffer, "Is complete", (Object)this.dataSetInformation.getIsCompleteFlag());
        buffer.setLength(buffer.length() - 1);
        buffer.append(']');
        return buffer.toString();
    }

    private String formatDate(Date productionDate) {
        return productionDate == null ? "" : DateFormatThreadLocal.DATE_FORMAT.get().format(productionDate);
    }

    private final void appendNameAndObject(StringBuilder buffer, String name, Object object) {
        if (object != null) {
            buffer.append(name).append("::").append(object).append(";");
        }
    }

    private String getEmail() {
        Experiment experiment = this.dataSetInformation.tryToGetExperiment();
        if (experiment == null) {
            throw new UserFailureException("Unknown experiment of data set " + this.dataSetInformation);
        }
        return experiment.getRegistrator().getEmail();
    }

    private boolean removeAndLog(String msg) {
        boolean ok = this.getFileOperations().removeRecursivelyQueueing(this.incomingDataSetFile);
        if (this.getOperationLog().isInfoEnabled()) {
            this.getOperationLog().info("Dataset deleted in registration: " + msg);
        }
        return ok;
    }

    private final void plainRegisterDataSet(NewExternalData data, String relativePath, StorageFormat storageFormat, BooleanOrUnknown isCompleteFlag) throws Throwable {
        this.updateExternalData(data, relativePath, storageFormat, isCompleteFlag);
        this.registerDataSetInApplicationServer(data);
        this.state.openBisService.setStorageConfirmed(data.getCode());
    }

    private final NewExternalData updateExternalData(NewExternalData data, String relativePath, StorageFormat storageFormat, BooleanOrUnknown isCompleteFlag) {
        data.setComplete(isCompleteFlag);
        data.setLocation(relativePath.substring(data.getShareId().length() + 1));
        data.setStorageFormat(storageFormat);
        return data;
    }

    private final File createProcessingMarkerFile() {
        File baseDirectory = this.baseDirectoryHolder.getBaseDirectory();
        File baseParentDirectory = baseDirectory.getParentFile();
        String processingDirName = baseDirectory.getName();
        File markerFile = new File(baseParentDirectory, ".MARKER_processing_" + processingDirName);
        try {
            this.getFileOperations().createNewFile(markerFile);
        }
        catch (IOExceptionUnchecked ex) {
            throw EnvironmentFailureException.fromTemplate(ex, "Cannot create marker file '%s'.", markerFile.getPath());
        }
        return markerFile;
    }

    private String createEntityDescription() {
        SampleIdentifier sampleIdentifier = this.dataSetInformation.getSampleIdentifier();
        if (sampleIdentifier != null) {
            return "sample '" + sampleIdentifier + "'";
        }
        return "experiment '" + this.dataSetInformation.getExperimentIdentifier() + "'";
    }

    private IFileOperations getFileOperations() {
        return this.state.fileOperations;
    }

    private IStorageProcessorTransactional getStorageProcessor() {
        return this.state.storageProcessor;
    }

    private IDataStoreStrategy getDataStoreStrategy() {
        return this.state.dataStoreStrategy;
    }

    private ITypeExtractor getTypeExtractor() {
        return this.state.typeExtractor;
    }

    private IDataSetValidator getDataSetValidator() {
        return this.state.dataSetValidator;
    }

    private Logger getNotificationLog() {
        return notificationLog;
    }

    private Logger getOperationLog() {
        return operationLog;
    }

    public File getIncomingDataSetFile() {
        return this.state.incomingDataSetFile;
    }

    public static class DataSetRegistrationAlgorithmState {
        private final File incomingDataSetFile;
        private final IEncapsulatedOpenBISService openBisService;
        private final IDelegatedActionWithResult<Boolean> cleanAfterwardsAction;
        private final IPreRegistrationAction preRegistrationAction;
        private final IPostRegistrationAction postRegistrationAction;
        private final DataSetInformation dataSetInformation;
        private final IDataStoreStrategy dataStoreStrategy;
        private final ITypeExtractor typeExtractor;
        private final IStorageProcessorTransactional storageProcessor;
        private IStorageProcessorTransactional.IStorageProcessorTransaction transaction;
        private final IFileOperations fileOperations;
        private final IDataSetValidator dataSetValidator;
        private final IMailClient mailClient;
        private final boolean shouldDeleteUnidentified;
        private final String dataStoreCode;
        private final Lock registrationLock;
        private final boolean shouldNotifySuccessfulRegistration;
        private final DataSetType dataSetType;
        private final File storeRoot;
        private final String defaultErrorMessageTemplate;
        private final String emailSubjectTemplate;

        public DataSetRegistrationAlgorithmState(File incomingDataSetFile, IEncapsulatedOpenBISService openBisService, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, IPreRegistrationAction preRegistrationAction, IPostRegistrationAction postRegistrationAction, DataSetInformation dataSetInformation, IDataStoreStrategy dataStoreStrategy, ITypeExtractor typeExtractor, IStorageProcessorTransactional storageProcessor, IFileOperations fileOperations, IDataSetValidator dataSetValidator, IMailClient mailClient, boolean shouldDeleteUnidentified, Lock registrationLock, String dataStoreCode, boolean shouldNotifySuccessfulRegistration) {
            this.incomingDataSetFile = incomingDataSetFile;
            this.openBisService = openBisService;
            this.cleanAfterwardsAction = cleanAfterwardsAction;
            this.preRegistrationAction = preRegistrationAction;
            this.postRegistrationAction = postRegistrationAction;
            this.dataSetInformation = dataSetInformation;
            this.dataStoreStrategy = dataStoreStrategy;
            this.typeExtractor = typeExtractor;
            this.storageProcessor = storageProcessor;
            this.fileOperations = fileOperations;
            this.dataSetValidator = dataSetValidator;
            this.mailClient = mailClient;
            this.shouldDeleteUnidentified = shouldDeleteUnidentified;
            this.registrationLock = registrationLock;
            this.dataStoreCode = dataStoreCode;
            this.shouldNotifySuccessfulRegistration = shouldNotifySuccessfulRegistration;
            if (dataSetInformation.getDataSetCode() == null) {
                dataSetInformation.setDataSetCode(openBisService.createPermId());
            }
            this.dataSetType = typeExtractor.getDataSetType(incomingDataSetFile);
            dataSetInformation.setDataSetType(this.dataSetType);
            this.storeRoot = storageProcessor.getStoreRootDirectory();
            this.defaultErrorMessageTemplate = DataSetRegistrationAlgorithm.DATA_SET_STORAGE_FAILURE_TEMPLATE;
            this.emailSubjectTemplate = DataSetRegistrationAlgorithm.EMAIL_SUBJECT_TEMPLATE;
        }

        public File getIncomingDataSetFile() {
            return this.incomingDataSetFile;
        }
    }

    private static class DefaultApplicationServerRegistrator
    implements IDataSetInApplicationServerRegistrator {
        private final IEncapsulatedOpenBISService openBisService;
        private final DataSetInformation dataSetInformation;

        DefaultApplicationServerRegistrator(DataSetRegistrationAlgorithmState state) {
            this.openBisService = state.openBisService;
            this.dataSetInformation = state.dataSetInformation;
        }

        @Override
        public void registerDataSetInApplicationServer(NewExternalData data) throws Throwable {
            this.openBisService.registerDataSet(this.dataSetInformation, data);
        }
    }

    public static interface IDataSetInApplicationServerRegistrator {
        public void registerDataSetInApplicationServer(NewExternalData var1) throws Throwable;
    }

    public static interface IRollbackDelegate {
        public void rollback(DataSetRegistrationAlgorithm var1, Throwable var2);
    }
}

