/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.DssUniqueFilenameGenerator;
import java.io.File;
import java.io.IOException;

public class DssRegistrationLogDirectoryHelper {
    private static final String IN_PROCESS_DIR_NAME = "in-process";
    private static final String SUCCEEDED_DIR_NAME = "succeeded";
    private static final String FAILED_DIR_NAME = "failed";
    private final File dssRegistrationLogDir;
    private final ITimeProvider timeProvider;

    public DssRegistrationLogDirectoryHelper(File dssRegistrationLogDir) {
        this(dssRegistrationLogDir, SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    public DssRegistrationLogDirectoryHelper(File dssRegistrationLogDir, ITimeProvider timeProvider) {
        this.dssRegistrationLogDir = dssRegistrationLogDir;
        this.timeProvider = timeProvider;
    }

    public void initializeSubdirectories() {
        this.createDirectoryIfNecessary(this.getInProcessDir());
        this.createDirectoryIfNecessary(this.getSucceededDir());
        this.createDirectoryIfNecessary(this.getFailedDir());
    }

    public File getInProcessDir() {
        return new File(this.dssRegistrationLogDir, IN_PROCESS_DIR_NAME);
    }

    public File getSucceededDir() {
        return new File(this.dssRegistrationLogDir, SUCCEEDED_DIR_NAME);
    }

    public File getFailedDir() {
        return new File(this.dssRegistrationLogDir, FAILED_DIR_NAME);
    }

    public DssRegistrationLogger createNewLogFile(String name, String threadName, IFileOperations fileOperations) {
        String logFilename = this.generateLogFileName(name, threadName);
        File logFile = new File(this.getInProcessDir(), logFilename);
        try {
            logFile.createNewFile();
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
        return new DssRegistrationLogger(logFile, this, fileOperations, this.timeProvider);
    }

    String generateLogFileName(String name, String threadName) {
        return new DssUniqueFilenameGenerator(this.timeProvider, threadName, name, ".log").generateFilename();
    }

    private void createDirectoryIfNecessary(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
    }
}

