/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.path.DatabaseBasedDataSetPathsInfoFeeder;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.etlserver.postregistration.NoCleanupTask;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class PathInfoDatabaseFeedingTask
implements IMaintenanceTask,
IPostRegistrationTask {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PathInfoDatabaseFeedingTask.class);
    static final String COMPUTE_CHECKSUM_KEY = "compute-checksum";
    static final String CHUNK_SIZE_KEY = "data-set-chunk-size";
    static final int DEFAULT_CHUNK_SIZE = 1000;
    static final String MAX_NUMBER_OF_CHUNKS_KEY = "max-number-of-chunks";
    static final int DEFAULT_MAX_NUMBER_OF_DATA_SETS = -1;
    static final String TIME_LIMIT_KEY = "time-limit";
    private IEncapsulatedOpenBISService service;
    private IDataSetDirectoryProvider directoryProvider;
    private ITimeProvider timeProvider;
    private IPathsInfoDAO dao;
    private IHierarchicalContentFactory hierarchicalContentFactory;
    private boolean computeChecksum;
    private int chunkSize;
    private int maxNumerOfChunks;
    private long timeLimit;

    private static IPathsInfoDAO createDAO() {
        return (IPathsInfoDAO)QueryTool.getQuery((DataSource)PathInfoDataSourceProvider.getDataSource(), IPathsInfoDAO.class);
    }

    private static IDataSetDirectoryProvider getDirectoryProvider() {
        return ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
    }

    private static IHierarchicalContentFactory createContentFactory() {
        return new DefaultFileBasedHierarchicalContentFactory();
    }

    public PathInfoDatabaseFeedingTask() {
    }

    public PathInfoDatabaseFeedingTask(Properties properties, IEncapsulatedOpenBISService service) {
        this(service, PathInfoDatabaseFeedingTask.getDirectoryProvider(), PathInfoDatabaseFeedingTask.createDAO(), PathInfoDatabaseFeedingTask.createContentFactory(), SystemTimeProvider.SYSTEM_TIME_PROVIDER, PathInfoDatabaseFeedingTask.getComputeChecksumFlag(properties), 0, 0, 0L);
    }

    @Private
    PathInfoDatabaseFeedingTask(IEncapsulatedOpenBISService service, IDataSetDirectoryProvider directoryProvider, IPathsInfoDAO dao, IHierarchicalContentFactory hierarchicalContentFactory, ITimeProvider timeProvider, boolean computeChecksum, int chunkSize, int maxNumberOfChunks, long timeLimit) {
        this.service = service;
        this.directoryProvider = directoryProvider;
        this.dao = dao;
        this.hierarchicalContentFactory = hierarchicalContentFactory;
        this.timeProvider = timeProvider;
        this.computeChecksum = computeChecksum;
        this.chunkSize = chunkSize;
        this.maxNumerOfChunks = maxNumberOfChunks;
        this.timeLimit = timeLimit;
    }

    @Override
    public boolean requiresDataStoreLock() {
        return false;
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        this.service = ServiceProvider.getOpenBISService();
        this.directoryProvider = PathInfoDatabaseFeedingTask.getDirectoryProvider();
        this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
        this.dao = PathInfoDatabaseFeedingTask.createDAO();
        this.hierarchicalContentFactory = PathInfoDatabaseFeedingTask.createContentFactory();
        this.computeChecksum = PathInfoDatabaseFeedingTask.getComputeChecksumFlag(properties);
        this.chunkSize = PropertyUtils.getInt(properties, CHUNK_SIZE_KEY, 1000);
        this.maxNumerOfChunks = PropertyUtils.getInt(properties, MAX_NUMBER_OF_CHUNKS_KEY, -1);
        this.timeLimit = DateTimeUtils.getDurationInMillis(properties, TIME_LIMIT_KEY, 0L);
        StringBuilder builder = new StringBuilder(pluginName);
        builder.append(" intialized with chunk size = ").append(this.chunkSize).append(".");
        if (this.timeLimit > 0L) {
            builder.append(" Time limit: ").append(DateTimeUtils.renderDuration(this.timeLimit));
        } else if (this.maxNumerOfChunks > 0) {
            builder.append(" Maximum number of chunks: ").append(this.maxNumerOfChunks);
        }
        operationLog.info(builder.toString());
    }

    private static boolean getComputeChecksumFlag(Properties properties) {
        return PropertyUtils.getBoolean(properties, COMPUTE_CHECKSUM_KEY, false);
    }

    @Override
    public void execute() {
        List<SimpleDataSetInformationDTO> dataSets;
        IStopCondition stopCondition = this.createStopCondition();
        int chunkCount = 0;
        operationLog.info("Start feeding.");
        do {
            dataSets = this.getNextChunk();
            operationLog.info("Feeding " + ++chunkCount + ". chunk. " + dataSets.size() + " data sets.");
            Date maxRegistrationTimestamp = null;
            for (SimpleDataSetInformationDTO dataSet : dataSets) {
                this.feedPathInfoDatabase(dataSet);
                Date registrationTimestamp = dataSet.getRegistrationTimestamp();
                if (maxRegistrationTimestamp == null || maxRegistrationTimestamp.getTime() < registrationTimestamp.getTime()) {
                    maxRegistrationTimestamp = registrationTimestamp;
                }
                stopCondition.handle(dataSet);
            }
            if (maxRegistrationTimestamp == null) continue;
            this.dao.deleteLastFeedingEvent();
            this.dao.createLastFeedingEvent(maxRegistrationTimestamp);
            this.dao.commit();
        } while (dataSets.size() >= this.chunkSize && !stopCondition.fulfilled());
        operationLog.info("Feeding finished.");
    }

    private List<SimpleDataSetInformationDTO> getNextChunk() {
        Date timestamp = this.dao.getRegistrationTimestampOfLastFeedingEvent();
        if (timestamp == null) {
            return this.service.listOldestPhysicalDataSets(this.chunkSize);
        }
        return this.service.listOldestPhysicalDataSets(timestamp, this.chunkSize);
    }

    @Override
    public IPostRegistrationTaskExecutor createExecutor(final String dataSetCode, boolean container) {
        return new IPostRegistrationTaskExecutor(){

            @Override
            public ICleanupTask createCleanupTask() {
                return new NoCleanupTask();
            }

            @Override
            public void execute() {
                AbstractExternalData dataSet = PathInfoDatabaseFeedingTask.this.service.tryGetDataSet(dataSetCode);
                if (dataSet == null) {
                    operationLog.error("Data set " + dataSetCode + " unknown to openBIS.");
                    return;
                }
                if (!dataSet.isContainer()) {
                    PhysicalDataSet dataSetLocation = dataSet.tryGetAsDataSet();
                    PathInfoDatabaseFeedingTask.this.feedPathInfoDatabase(dataSetLocation);
                }
            }
        };
    }

    private void feedPathInfoDatabase(IDatasetLocation dataSet) {
        IShareIdManager shareIdManager = this.directoryProvider.getShareIdManager();
        String dataSetCode = dataSet.getDataSetCode();
        shareIdManager.lock(dataSetCode);
        try {
            File dataSetRoot = this.directoryProvider.getDataSetDirectory(dataSet);
            if (!dataSetRoot.exists()) {
                operationLog.error("Root directory of data set " + dataSetCode + " does not exists: " + dataSetRoot);
                shareIdManager.releaseLocks();
                return;
            }
            try {
                DatabaseBasedDataSetPathsInfoFeeder feeder = new DatabaseBasedDataSetPathsInfoFeeder(this.dao, this.hierarchicalContentFactory, this.computeChecksum);
                Long id = this.dao.tryGetDataSetId(dataSetCode);
                if (id == null) {
                    feeder.addPaths(dataSetCode, dataSet.getDataSetLocation(), dataSetRoot);
                    feeder.commit();
                    operationLog.info("Paths inside data set " + dataSetCode + " successfully added to database.");
                }
            }
            catch (Exception ex) {
                this.handleException(ex, dataSetCode);
            }
        }
        finally {
            shareIdManager.releaseLocks();
        }
    }

    private void handleException(Exception ex, String dataSet) {
        operationLog.error("Couldn't feed database with path infos of data set " + dataSet, ex);
        this.dao.rollback();
    }

    private IStopCondition createStopCondition() {
        if (this.timeLimit > 0L) {
            return this.createStopConditionForTimeLimit();
        }
        if (this.maxNumerOfChunks > 0) {
            return this.createStopConditionForMaxNumber();
        }
        return new IStopCondition(){

            @Override
            public void handle(SimpleDataSetInformationDTO dataSet) {
            }

            @Override
            public boolean fulfilled() {
                return false;
            }
        };
    }

    private IStopCondition createStopConditionForMaxNumber() {
        return new IStopCondition(){
            private int count;

            @Override
            public void handle(SimpleDataSetInformationDTO dataSet) {
            }

            @Override
            public boolean fulfilled() {
                return ++this.count >= PathInfoDatabaseFeedingTask.this.maxNumerOfChunks;
            }
        };
    }

    private IStopCondition createStopConditionForTimeLimit() {
        return new IStopCondition(){
            private long startTime;
            {
                this.startTime = PathInfoDatabaseFeedingTask.this.timeProvider.getTimeInMilliseconds();
            }

            @Override
            public void handle(SimpleDataSetInformationDTO dataSet) {
            }

            @Override
            public boolean fulfilled() {
                return PathInfoDatabaseFeedingTask.this.timeProvider.getTimeInMilliseconds() - this.startTime > PathInfoDatabaseFeedingTask.this.timeLimit;
            }
        };
    }

    private static interface IStopCondition {
        public void handle(SimpleDataSetInformationDTO var1);

        public boolean fulfilled();
    }
}

