/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.etlserver.plugins.AbstractDataSetDeletionPostProcessingMaintenanceTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DeleteDataSetsAlreadyDeletedInApplicationServerMaintenanceTask
extends AbstractDataSetDeletionPostProcessingMaintenanceTask {
    static final String TIMING_PARAMETERS_KEY = "timing-parameters";
    static final String LAST_SEEN_DATA_SET_FILE_PROPERTY = "last-seen-data-set-file";
    private static final String LAST_SEEN_DATA_SET_FILE_DEFAULT = "deleteDatasetsAlreadyDeletedFromApplicationServerTaskLastSeen";
    private File lastSeenDataSetFile;
    private TimingParameters timingParameters;

    @Override
    public void setUp(String pluginName, Properties properties) {
        super.setUp(pluginName, properties);
        String lastSeenDataSetFileProperty = properties.getProperty(LAST_SEEN_DATA_SET_FILE_PROPERTY);
        this.lastSeenDataSetFile = lastSeenDataSetFileProperty == null ? new File(this.getConfigProvider().getStoreRoot(), LAST_SEEN_DATA_SET_FILE_DEFAULT) : new File(lastSeenDataSetFileProperty);
        this.timingParameters = TimingParameters.create(PropertyParametersUtil.extractSingleSectionProperties(properties, TIMING_PARAMETERS_KEY, false).getProperties());
    }

    @Override
    protected Long getLastSeenEventId() {
        if (this.lastSeenDataSetFile.exists()) {
            String lastSeenEventId = FileUtilities.loadToString(this.lastSeenDataSetFile).trim();
            try {
                return Long.valueOf(lastSeenEventId);
            }
            catch (NumberFormatException numberFormatException) {
                operationLog.error("Couldn't get the last seen data set from file: " + this.lastSeenDataSetFile.getAbsolutePath() + " because the contents of that file cannot be parsed to a long value. " + " As there is no last seen data set available all data sets deletions will be taken into consideration.");
                return null;
            }
        }
        return null;
    }

    @Override
    protected void updateLastSeenEventId(Long eventId) {
        FileUtilities.writeToFile(this.lastSeenDataSetFile, String.valueOf(eventId));
    }

    @Override
    protected void execute(List<DeletedDataSet> datasets) {
        operationLog.info("Got " + datasets.size() + " deletions to process");
        this.deleteKnownDatasets(datasets);
        this.deleteUnknownDatasets(datasets);
    }

    private void deleteKnownDatasets(List<DeletedDataSet> datasets) {
        ArrayList<DatasetLocation> locations = new ArrayList<DatasetLocation>();
        for (DeletedDataSet dataset : datasets) {
            if (!this.isKnownDataset(dataset)) continue;
            operationLog.info("Is going to delete a known data set: " + dataset.getCode());
            DatasetLocation location = new DatasetLocation();
            location.setDatasetCode(dataset.getCode());
            location.setDataSetLocation(dataset.getLocationOrNull());
            locations.add(location);
        }
        if (!locations.isEmpty()) {
            this.getService().getDataSetDeleter().scheduleDeletionOfDataSets(locations, this.timingParameters.getMaxRetriesOnFailure(), this.timingParameters.getIntervalToWaitAfterFailureMillis());
        }
    }

    private void deleteUnknownDatasets(List<DeletedDataSet> datasets) {
        Log4jSimpleLogger logger = new Log4jSimpleLogger(operationLog);
        IDataSetDirectoryProvider directoryProvider = this.getDirectoryProvider();
        DataSetExistenceChecker dataSetExistenceChecker = new DataSetExistenceChecker(directoryProvider, this.timingParameters);
        for (DeletedDataSet dataset : datasets) {
            if (!this.isUnknownDatasets(dataset) || !dataSetExistenceChecker.dataSetExists(dataset)) continue;
            File datasetDir = directoryProvider.getDataSetDirectory(dataset.getShareIdOrNull(), dataset.getLocationOrNull());
            operationLog.info("Is going to delete an unknown data set: " + dataset.getCode());
            SegmentedStoreUtils.deleteDataSetInstantly(dataset.getCode(), datasetDir, logger);
        }
    }

    private boolean isKnownDataset(DeletedDataSet dataset) {
        boolean isLocationSpecified;
        String dataStoreCode = this.getConfigProvider().getDataStoreCode();
        boolean isDataStoreMatching = dataStoreCode.equals(dataset.getDatastoreCodeOrNull());
        boolean isKnown = this.getShareIdManager().isKnown(dataset.getCode());
        boolean bl = isLocationSpecified = dataset.getLocationOrNull() != null;
        return isDataStoreMatching && isKnown && isLocationSpecified;
    }

    private boolean isUnknownDatasets(DeletedDataSet dataset) {
        boolean isShareIdSpecified;
        String dataStoreCode = this.getConfigProvider().getDataStoreCode();
        boolean isDataStoreMatching = dataStoreCode.equals(dataset.getDatastoreCodeOrNull());
        boolean isKnown = this.getShareIdManager().isKnown(dataset.getCode());
        boolean isLocationSpecified = dataset.getLocationOrNull() != null;
        boolean bl = isShareIdSpecified = dataset.getShareIdOrNull() != null;
        return isDataStoreMatching && !isKnown && isLocationSpecified && isShareIdSpecified;
    }

    private IDataStoreServiceInternal getService() {
        return ServiceProvider.getDataStoreService();
    }

    private IConfigProvider getConfigProvider() {
        return ServiceProvider.getConfigProvider();
    }

    private IShareIdManager getShareIdManager() {
        return ServiceProvider.getShareIdManager();
    }

    private IDataSetDirectoryProvider getDirectoryProvider() {
        return new DataSetDirectoryProvider(this.getConfigProvider().getStoreRoot(), this.getShareIdManager());
    }
}

