/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.etlserver.plugins.MonitoredDirectory;
import ch.systemsx.cisd.etlserver.plugins.WriteDirectoryNameToDropboxAction;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileSystemMonitoringMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileSystemMonitoringMaintenanceTask.class);
    public static final String READY_TO_IMPORT_MARKER_FILE = "ready-to-import-marker-file";
    public static final String IMPORTED_MARKER_FILE = "imported-marker-file";
    public static final String MONITORED_DIRECTORIES = "monitored-directories";
    public static final String DROPBOX_DIRECTORY = "dropbox-directory";
    private String dropboxDirectory;
    private String readyToImportMarkerFile;
    private String alreadyImportedMarkerFile;
    private Collection<MonitoredDirectory> monitoredDirectories;

    @Override
    public void setUp(String pluginName, Properties properties) {
        this.readyToImportMarkerFile = properties.getProperty(READY_TO_IMPORT_MARKER_FILE);
        this.alreadyImportedMarkerFile = properties.getProperty(IMPORTED_MARKER_FILE);
        this.dropboxDirectory = properties.getProperty(DROPBOX_DIRECTORY);
        String directories = properties.getProperty(MONITORED_DIRECTORIES);
        if (this.readyToImportMarkerFile == null || this.readyToImportMarkerFile.length() == 0) {
            this.readyToImportMarkerFile = ".ready-to-import";
        }
        if (this.alreadyImportedMarkerFile == null || this.alreadyImportedMarkerFile.length() == 0) {
            this.alreadyImportedMarkerFile = ".import-complete";
        }
        this.monitoredDirectories = new HashSet<MonitoredDirectory>();
        if (directories != null) {
            String[] stringArray = directories.split("\\,");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File monitoredDirectory = new File(fileName.trim());
                try {
                    this.monitoredDirectories.add(new MonitoredDirectory(monitoredDirectory, this.readyToImportMarkerFile, this.alreadyImportedMarkerFile));
                }
                catch (RuntimeException e) {
                    operationLog.error("Cannot monitor directory " + monitoredDirectory.getAbsolutePath() + ": " + e.getMessage());
                }
                ++n2;
            }
        }
    }

    @Override
    public void execute() {
        if (this.monitoredDirectories.isEmpty()) {
            operationLog.warn("No directories to monitor - doing nothing.");
            return;
        }
        if (this.dropboxDirectory == null || this.dropboxDirectory.length() == 0) {
            operationLog.warn("Dropbox directory not defined - doing nothing.");
            return;
        }
        for (MonitoredDirectory directory : this.monitoredDirectories) {
            directory.perform(new WriteDirectoryNameToDropboxAction(new File(this.dropboxDirectory)));
        }
    }
}

