/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.utils.FileScanner;
import ch.systemsx.cisd.etlserver.utils.TabSeparatedValueTable;
import ch.systemsx.cisd.etlserver.validation.ColumnDefinition;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import ch.systemsx.cisd.etlserver.validation.Result;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class DataSetValidatorForTSV
implements IDataSetValidator {
    static final String PATH_PATTERNS_KEY = "path-patterns";
    static final String EXCLUDE_PATH_PATTERNS_KEY = "exclude-path-patterns";
    static final String IGNORE_EMPTY_LINES_KEY = "ignore-empty-lines";
    static final String STRICT_ROW_SIZE_KEY = "strict-row-size";
    static final String COLUMNS_KEY = "columns";
    private final List<FileScanner> fileScanners = new ArrayList<FileScanner>();
    private final List<FileScanner> excludeFileScanners;
    private final List<ColumnDefinition> unorderedDefinitions;
    private final Map<Integer, ColumnDefinition> orderedDefinitions;
    private final boolean ignoreEmptyLines;
    private final boolean strictRowSize;

    public DataSetValidatorForTSV(Properties properties) {
        PropertyParametersUtil.SectionProperties[] columnsProperties;
        this.ignoreEmptyLines = PropertyUtils.getBoolean(properties, IGNORE_EMPTY_LINES_KEY, true);
        this.strictRowSize = PropertyUtils.getBoolean(properties, STRICT_ROW_SIZE_KEY, true);
        String pathPatterns = properties.getProperty(PATH_PATTERNS_KEY, "*");
        StringTokenizer tokenizer = new StringTokenizer(pathPatterns, ",");
        while (tokenizer.hasMoreTokens()) {
            String pathPattern = tokenizer.nextToken().trim();
            this.fileScanners.add(new FileScanner(pathPattern));
        }
        this.excludeFileScanners = new ArrayList<FileScanner>();
        String excludePathPatterns = properties.getProperty(EXCLUDE_PATH_PATTERNS_KEY);
        if (excludePathPatterns != null) {
            tokenizer = new StringTokenizer(excludePathPatterns, ",");
            while (tokenizer.hasMoreTokens()) {
                String pathPattern = tokenizer.nextToken().trim();
                this.excludeFileScanners.add(new FileScanner(pathPattern));
            }
        }
        this.unorderedDefinitions = new ArrayList<ColumnDefinition>();
        this.orderedDefinitions = new LinkedHashMap<Integer, ColumnDefinition>();
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = columnsProperties = PropertyParametersUtil.extractSectionProperties(properties, COLUMNS_KEY, false);
        int n = columnsProperties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperties = sectionPropertiesArray[n2];
            try {
                String name = sectionProperties.getKey();
                ColumnDefinition definition = ColumnDefinition.create(name, sectionProperties.getProperties());
                Integer orderOrNull = definition.getOrderOrNull();
                if (orderOrNull == null) {
                    this.unorderedDefinitions.add(definition);
                } else {
                    ColumnDefinition previousDefinition = this.orderedDefinitions.put(orderOrNull, definition);
                    if (previousDefinition != null) {
                        throw new ConfigurationFailureException("There is already a column definied for order " + orderOrNull + ".");
                    }
                }
            }
            catch (Exception ex) {
                throw new ConfigurationFailureException("Couldn't create column definition '" + sectionProperties.getKey() + "': " + ex.getMessage(), ex);
            }
            ++n2;
        }
    }

    @Override
    public void assertValidDataSet(DataSetType dataSetType, File incomingDataSetFileOrFolder) {
        HashSet<File> excludedFiles = new HashSet<File>();
        for (FileScanner fileScanner : this.excludeFileScanners) {
            excludedFiles.addAll(fileScanner.scan(incomingDataSetFileOrFolder));
        }
        for (FileScanner fileScanner : this.fileScanners) {
            List<File> files = fileScanner.scan(incomingDataSetFileOrFolder);
            for (File file : files) {
                if (excludedFiles.contains(file)) continue;
                this.assertValidFile(dataSetType, file);
            }
        }
    }

    private void assertValidFile(DataSetType dataSetType, File file) {
        if (!file.isFile()) {
            return;
        }
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(file);
                String dataSourceName = file.toString();
                this.assertValidDataSet(dataSetType, reader, dataSourceName);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    @Override
    public void assertValidDataSet(DataSetType dataSetType, Reader reader, String dataSourceName) {
        TabSeparatedValueTable table = new TabSeparatedValueTable(reader, dataSourceName, this.ignoreEmptyLines, this.strictRowSize, false);
        List<String> headers = table.getHeaders();
        this.assertUniqueHeaders(headers);
        ColumnDefinition[] definitions = this.findColumnDefinitions(headers);
        IValidator[] validators = new IValidator[definitions.length];
        int i = 0;
        while (i < validators.length) {
            validators[i] = definitions[i].createValidator(headers.get(i));
            ++i;
        }
        int lineNumber = 1;
        while (table.hasMoreRows()) {
            int i2;
            ++lineNumber;
            List<String> row = table.tryToGetNextRow();
            if (row.size() > definitions.length) {
                i2 = definitions.length;
                while (i2 < row.size()) {
                    if (StringUtils.isNotBlank((String)row.get(i2))) {
                        throw new UserFailureException("The row in line " + lineNumber + " has " + row.size() + " cells instead of " + definitions.length);
                    }
                    ++i2;
                }
            }
            i2 = 0;
            int n = Math.min(row.size(), validators.length);
            while (i2 < n) {
                try {
                    validators[i2].assertValid(row.get(i2));
                }
                catch (RuntimeException ex) {
                    throw new UserFailureException("Error in file '" + dataSourceName + "': " + (i2 + 1) + ". cell in line " + lineNumber + ": " + ex.getMessage(), ex);
                }
                ++i2;
            }
        }
    }

    private void assertUniqueHeaders(List<String> headers) {
        HashSet<String> headerSet = new HashSet<String>();
        for (String header : headers) {
            if (headerSet.contains(header)) {
                throw new UserFailureException("Column header '" + header + "' appeared twice.");
            }
            headerSet.add(header);
        }
    }

    private ColumnDefinition[] findColumnDefinitions(List<String> columnHeaders) {
        ColumnDefinition[] definitions = this.findOrderedColumnDefinitions(columnHeaders);
        LinkedList<ColumnDefinition> remainingDefinitions = new LinkedList<ColumnDefinition>(this.unorderedDefinitions);
        int i = 0;
        while (i < definitions.length) {
            if (definitions[i] == null) {
                ColumnDefinition orderedColumDefinitionOrNull = this.orderedDefinitions.get(i + 1);
                definitions[i] = this.getDefinition(remainingDefinitions, orderedColumDefinitionOrNull, columnHeaders, i);
            }
            ++i;
        }
        String list = this.createListOfMissingColumns(remainingDefinitions);
        if (list.length() > 0) {
            throw new UserFailureException("No column(s) found for the following mandatory column definition(s): " + list);
        }
        return definitions;
    }

    private String createListOfMissingColumns(List<ColumnDefinition> remainingDefinitions) {
        StringBuilder builder = new StringBuilder();
        for (ColumnDefinition columnDefinition : remainingDefinitions) {
            if (!columnDefinition.isMandatory()) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(columnDefinition.getName());
        }
        return builder.toString();
    }

    private ColumnDefinition[] findOrderedColumnDefinitions(List<String> columnHeaders) {
        ColumnDefinition[] definitions = new ColumnDefinition[columnHeaders.size()];
        for (ColumnDefinition columnDefinition : this.orderedDefinitions.values()) {
            boolean mandatory = columnDefinition.isMandatory();
            int orderIndex = columnDefinition.getOrderOrNull() - 1;
            if (orderIndex >= columnHeaders.size()) {
                if (!mandatory) continue;
                throw new UserFailureException(columnDefinition.getOrderOrNull() + ". column [name=" + columnDefinition.getName() + "] is mandatory but missing because there are only " + columnHeaders.size() + " column headers.");
            }
            String header = columnHeaders.get(orderIndex);
            Result result = columnDefinition.validateHeader(header);
            if (result.isValid()) {
                definitions[orderIndex] = columnDefinition;
                continue;
            }
            if (!mandatory) continue;
            throw new UserFailureException("According to column definition '" + columnDefinition.getName() + "' the header '" + header + "' is invalid because of the following reason: " + result);
        }
        return definitions;
    }

    private ColumnDefinition getDefinition(List<ColumnDefinition> definitions, ColumnDefinition orderedColumDefinitionOrNull, List<String> columnHeaders, int i) {
        Result result;
        String columnHeader = columnHeaders.get(i);
        StringBuilder builder = new StringBuilder();
        Iterator<ColumnDefinition> iterator = definitions.iterator();
        while (iterator.hasNext()) {
            ColumnDefinition columnDefinition = iterator.next();
            Result result2 = columnDefinition.validateHeader(columnHeader);
            if (result2.isValid()) {
                if (!columnDefinition.canDefineMultipleColumns()) {
                    iterator.remove();
                }
                return columnDefinition;
            }
            this.addMessage(builder, columnDefinition, result2);
        }
        if (orderedColumDefinitionOrNull != null && !(result = orderedColumDefinitionOrNull.validateHeader(columnHeader)).isValid()) {
            this.addMessage(builder, orderedColumDefinitionOrNull, result);
        }
        throw new UserFailureException("No column definition matches the header of the " + (i + 1) + ". column: " + columnHeader + builder);
    }

    private void addMessage(StringBuilder builder, ColumnDefinition columnDefinition, Result result) {
        builder.append("\nColumn Definition '").append(columnDefinition.getName());
        builder.append("' does not match: Reason: ").append(result);
    }
}

