/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.EntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationGroupDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ICorePluginDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSetTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDatabaseInstanceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityHistoryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityOperationsLogDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IFileFormatTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomColumnDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomFilterDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ILocatorTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPostRegistrationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IQueryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IScriptDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyTermDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ICodeSequenceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IPermIdDAO;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Identifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;

abstract class AbstractBusinessObject
implements IDAOFactory {
    private final IDAOFactory daoFactory;
    protected final Session session;
    protected final IEntityPropertiesConverter entityPropertiesConverter;
    protected final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    private static final String ERR_MODIFIED_ENTITY = "%s has been modified in the meantime. Reopen tab to be able to continue with refreshed data.";

    AbstractBusinessObject(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(daoFactory, session, (IEntityPropertiesConverter)null, managedPropertyEvaluatorFactory);
    }

    AbstractBusinessObject(IDAOFactory daoFactory, Session session, EntityKind entityKindOrNull, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(daoFactory, session, entityKindOrNull == null ? null : new EntityPropertiesConverter(entityKindOrNull, daoFactory, managedPropertyEvaluatorFactory), managedPropertyEvaluatorFactory);
    }

    AbstractBusinessObject(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter converter, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        assert (daoFactory != null) : "Given DAO factory can not be null.";
        assert (session != null) : "Given session can not be null.";
        this.daoFactory = daoFactory;
        this.session = session;
        this.entityPropertiesConverter = converter;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.daoFactory.getSessionFactory();
    }

    protected final PersonPE findPerson() {
        PersonPE actor = this.session.tryGetPerson();
        assert (actor != null) : "Missing person instance in session object.";
        return actor;
    }

    protected void fillSpaceIdentifiers(List<? extends SpaceIdentifier> spaceIdentifiers) {
        if (spaceIdentifiers != null) {
            for (SpaceIdentifier spaceIdentifier : spaceIdentifiers) {
                this.fillSpaceIdentifier(spaceIdentifier);
            }
        }
    }

    protected void fillSpaceIdentifier(SpaceIdentifier spaceIdentifier) {
        if (StringUtils.isBlank((String)spaceIdentifier.getSpaceCode())) {
            SpacePE space = SpaceIdentifierHelper.tryGetSpace(spaceIdentifier, this.findPerson(), this);
            AbstractBusinessObject.checkNotNull(spaceIdentifier, space);
            spaceIdentifier.setDatabaseInstanceCode(space.getDatabaseInstance().getCode());
            spaceIdentifier.setSpaceCode(space.getCode());
        }
    }

    private static void checkNotNull(SpaceIdentifier spaceIdentifier, SpacePE group) {
        if (group == null) {
            throw new UserFailureException("Unknown space '" + spaceIdentifier + "'.");
        }
    }

    protected static final void throwException(DataAccessException exception, String subject) throws UserFailureException {
        AbstractBusinessObject.throwException(exception, subject, null);
    }

    protected static final void throwException(DataAccessException exception, String subject, EntityKind entityKindOrNull) throws UserFailureException {
        DataAccessExceptionTranslator.throwException(exception, subject, entityKindOrNull);
    }

    protected static final void throwEntityInUseException(String subject, EntityKind entityKindOrNull) throws UserFailureException {
        DataAccessExceptionTranslator.throwForeignKeyViolationException(subject, entityKindOrNull);
    }

    protected static final void throwModifiedEntityException(String entityName) {
        throw UserFailureException.fromTemplate(ERR_MODIFIED_ENTITY, entityName);
    }

    protected String getOrCreatePermID(Identifier<?> identifier) {
        String permID = identifier.getPermID();
        return permID == null ? this.getPermIdDAO().createPermId() : permID;
    }

    Set<String> extractPropertiesCodes(List<IEntityProperty> properties) {
        HashSet<String> propertiesCodes = new HashSet<String>();
        if (properties != null) {
            for (IEntityProperty property : properties) {
                propertiesCodes.add(property.getPropertyType().getCode());
            }
        }
        return propertiesCodes;
    }

    protected <T extends EntityPropertyPE> Set<T> convertProperties(EntityTypePE type, Set<T> existingProperties, List<IEntityProperty> properties, Set<String> propertiesToUpdate) {
        PersonPE registrator = this.findPerson();
        return this.entityPropertiesConverter.updateProperties(existingProperties, type, properties, registrator, propertiesToUpdate);
    }

    protected void setMetaprojects(IEntityWithMetaprojects entity, String[] metaprojectsOrNull) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        if (metaprojectsOrNull == null) {
            return;
        }
        PersonPE owner = this.getPersonDAO().tryFindPersonByUserId(this.session.getUserName());
        HashSet<MetaprojectPE> metaprojects = new HashSet<MetaprojectPE>();
        String[] stringArray = metaprojectsOrNull;
        int n = metaprojectsOrNull.length;
        int n2 = 0;
        while (n2 < n) {
            String metaprojectsOrNullItem = stringArray[n2];
            if (metaprojectsOrNullItem == null) {
                throw new IllegalArgumentException("Metaproject cannot be null");
            }
            MetaprojectPE metaproject = this.getMetaprojectDAO().tryFindByOwnerAndName(this.session.getUserName(), metaprojectsOrNullItem);
            if (metaproject == null) {
                metaproject = new MetaprojectPE();
                metaproject.setName(metaprojectsOrNullItem);
                metaproject.setOwner(owner);
                this.getMetaprojectDAO().createOrUpdateMetaproject(metaproject, owner);
            }
            metaprojects.add(metaproject);
            ++n2;
        }
        Collection<Object> currentMetaprojects = null;
        currentMetaprojects = entity.getId() != null ? this.getMetaprojectDAO().listMetaprojectsForEntity(owner, entity) : new HashSet();
        HashSet<MetaprojectPE> metaprojectsToAdd = new HashSet<MetaprojectPE>();
        HashSet<MetaprojectPE> metaprojectsToRemove = new HashSet<MetaprojectPE>();
        for (MetaprojectPE metaprojectPE : metaprojects) {
            if (currentMetaprojects.contains(metaprojectPE)) continue;
            metaprojectsToAdd.add(metaprojectPE);
        }
        for (MetaprojectPE metaprojectPE : currentMetaprojects) {
            if (metaprojects.contains(metaprojectPE)) continue;
            metaprojectsToRemove.add(metaprojectPE);
        }
        for (MetaprojectPE metaprojectPE : metaprojectsToAdd) {
            entity.addMetaproject(metaprojectPE);
        }
        for (MetaprojectPE metaprojectPE : metaprojectsToRemove) {
            entity.removeMetaproject(metaprojectPE);
        }
    }

    @Override
    public final DatabaseInstancePE getHomeDatabaseInstance() {
        return this.daoFactory.getHomeDatabaseInstance();
    }

    @Override
    public final ISpaceDAO getSpaceDAO() {
        return this.daoFactory.getSpaceDAO();
    }

    @Override
    public final IScriptDAO getScriptDAO() {
        return this.daoFactory.getScriptDAO();
    }

    @Override
    public final IPersonDAO getPersonDAO() {
        return this.daoFactory.getPersonDAO();
    }

    @Override
    public final IDatabaseInstanceDAO getDatabaseInstanceDAO() {
        return this.daoFactory.getDatabaseInstanceDAO();
    }

    @Override
    public final IRoleAssignmentDAO getRoleAssignmentDAO() {
        return this.daoFactory.getRoleAssignmentDAO();
    }

    @Override
    public final ISampleDAO getSampleDAO() {
        return this.daoFactory.getSampleDAO();
    }

    @Override
    public final ISampleTypeDAO getSampleTypeDAO() {
        return this.daoFactory.getSampleTypeDAO();
    }

    @Override
    public final IDataDAO getDataDAO() {
        return this.daoFactory.getDataDAO();
    }

    @Override
    public final IHibernateSearchDAO getHibernateSearchDAO() {
        return this.daoFactory.getHibernateSearchDAO();
    }

    @Override
    public IPropertyTypeDAO getPropertyTypeDAO() {
        return this.daoFactory.getPropertyTypeDAO();
    }

    @Override
    public IEntityTypeDAO getEntityTypeDAO(EntityKind entityKind) {
        return this.daoFactory.getEntityTypeDAO(entityKind);
    }

    @Override
    public IEntityPropertyTypeDAO getEntityPropertyTypeDAO(EntityKind entityKind) {
        return this.daoFactory.getEntityPropertyTypeDAO(entityKind);
    }

    @Override
    public IEntityHistoryDAO getEntityPropertyHistoryDAO() {
        return this.daoFactory.getEntityPropertyHistoryDAO();
    }

    @Override
    public IExperimentDAO getExperimentDAO() {
        return this.daoFactory.getExperimentDAO();
    }

    @Override
    public IProjectDAO getProjectDAO() {
        return this.daoFactory.getProjectDAO();
    }

    @Override
    public final IVocabularyDAO getVocabularyDAO() {
        return this.daoFactory.getVocabularyDAO();
    }

    @Override
    public final IVocabularyTermDAO getVocabularyTermDAO() {
        return this.daoFactory.getVocabularyTermDAO();
    }

    @Override
    public final IAttachmentDAO getAttachmentDAO() {
        return this.daoFactory.getAttachmentDAO();
    }

    @Override
    public IDataSetTypeDAO getDataSetTypeDAO() {
        return this.daoFactory.getDataSetTypeDAO();
    }

    @Override
    public IFileFormatTypeDAO getFileFormatTypeDAO() {
        return this.daoFactory.getFileFormatTypeDAO();
    }

    @Override
    public ILocatorTypeDAO getLocatorTypeDAO() {
        return this.daoFactory.getLocatorTypeDAO();
    }

    @Override
    public IMaterialDAO getMaterialDAO() {
        return this.daoFactory.getMaterialDAO();
    }

    @Override
    public ICodeSequenceDAO getCodeSequenceDAO() {
        return this.daoFactory.getCodeSequenceDAO();
    }

    @Override
    public IDataStoreDAO getDataStoreDAO() {
        return this.daoFactory.getDataStoreDAO();
    }

    @Override
    public IPermIdDAO getPermIdDAO() {
        return this.daoFactory.getPermIdDAO();
    }

    @Override
    public IEventDAO getEventDAO() {
        return this.daoFactory.getEventDAO();
    }

    @Override
    public final IDeletionDAO getDeletionDAO() {
        return this.daoFactory.getDeletionDAO();
    }

    @Override
    public void setBatchUpdateMode(boolean batchMode) {
        this.daoFactory.setBatchUpdateMode(batchMode);
    }

    @Override
    public IAuthorizationGroupDAO getAuthorizationGroupDAO() {
        return this.daoFactory.getAuthorizationGroupDAO();
    }

    @Override
    public PersistencyResources getPersistencyResources() {
        return this.daoFactory.getPersistencyResources();
    }

    @Override
    public IGridCustomFilterDAO getGridCustomFilterDAO() {
        return this.daoFactory.getGridCustomFilterDAO();
    }

    @Override
    public IGridCustomColumnDAO getGridCustomColumnDAO() {
        return this.daoFactory.getGridCustomColumnDAO();
    }

    @Override
    public IQueryDAO getQueryDAO() {
        return this.daoFactory.getQueryDAO();
    }

    @Override
    public IRelationshipTypeDAO getRelationshipTypeDAO() {
        return this.daoFactory.getRelationshipTypeDAO();
    }

    @Override
    public ICorePluginDAO getCorePluginDAO() {
        return this.daoFactory.getCorePluginDAO();
    }

    @Override
    public IPostRegistrationDAO getPostRegistrationDAO() {
        return this.daoFactory.getPostRegistrationDAO();
    }

    @Override
    public IEntityOperationsLogDAO getEntityOperationsLogDAO() {
        return this.daoFactory.getEntityOperationsLogDAO();
    }

    @Override
    public IExternalDataManagementSystemDAO getExternalDataManagementSystemDAO() {
        return this.daoFactory.getExternalDataManagementSystemDAO();
    }

    @Override
    public IMetaprojectDAO getMetaprojectDAO() {
        return this.daoFactory.getMetaprojectDAO();
    }

    protected void updateProperties(EntityTypePE entityType, List<IEntityProperty> properties, Set<String> propertiesToUpdate, IEntityPropertiesHolder entityAsPropertiesHolder, IModifierAndModificationDateBean entityAsModifiableBean) {
        Set<? extends EntityPropertyPE> existingProperties = entityAsPropertiesHolder.getProperties();
        HashMap<String, Object> existingPropertyValuesByCode = new HashMap<String, Object>();
        for (EntityPropertyPE entityPropertyPE : existingProperties) {
            String propertyCode = entityPropertyPE.getEntityTypePropertyType().getPropertyType().getCode();
            existingPropertyValuesByCode.put(propertyCode, this.getValue(entityPropertyPE));
        }
        Set<? extends EntityPropertyPE> set = this.convertProperties(entityType, existingProperties, properties, propertiesToUpdate);
        if (!this.isEquals(existingPropertyValuesByCode, set)) {
            entityAsPropertiesHolder.setProperties(set);
            entityAsModifiableBean.setModifier(this.findPerson());
            entityAsModifiableBean.setModificationDate(new Date());
        }
    }

    private boolean isEquals(Map<String, Object> existingPropertyValuesByCode, Set<? extends EntityPropertyPE> properties) {
        for (EntityPropertyPE entityPropertyPE : properties) {
            Object existingValue = existingPropertyValuesByCode.remove(entityPropertyPE.getEntityTypePropertyType().getPropertyType().getCode());
            if (existingValue != null && existingValue.equals(this.getValue(entityPropertyPE))) continue;
            return false;
        }
        return existingPropertyValuesByCode.isEmpty();
    }

    private Object getValue(EntityPropertyPE property) {
        String value = property.getValue();
        if (value != null) {
            return value;
        }
        MaterialPE materialValue = property.getMaterialValue();
        if (materialValue != null) {
            return materialValue;
        }
        return property.getVocabularyTerm();
    }

    protected AttachmentPE prepareAttachment(IModifierAndModificationDateBean beanOrNull, NewAttachment attachment) {
        AttachmentPE attachmentPE = AttachmentTranslator.translate(attachment);
        this.prepareAttachment(beanOrNull, attachmentPE);
        return attachmentPE;
    }

    protected void prepareAttachment(IModifierAndModificationDateBean beanOrNull, AttachmentPE attachment) {
        PersonPE user = this.findPerson();
        attachment.setRegistrator(user);
        this.escapeFileName(attachment);
        RelationshipUtils.updateModificationDateAndModifier(beanOrNull, user);
    }

    private void escapeFileName(AttachmentPE attachment) {
        if (attachment != null) {
            attachment.setFileName(AttachmentHolderPE.escapeFileName(attachment.getFileName()));
        }
    }

    protected void addAttachments(IModifierAndModificationDateBean holder, Collection<NewAttachment> newAttachments, List<AttachmentPE> attachments) {
        if (newAttachments == null) {
            return;
        }
        for (NewAttachment attachment : newAttachments) {
            attachments.add(this.prepareAttachment(holder, attachment));
        }
    }

    protected void saveAttachment(AttachmentHolderPE attachmentHolder, List<AttachmentPE> attachments) {
        if (attachments.isEmpty()) {
            return;
        }
        AttachmentHolderPE actualAttachmentHolder = attachmentHolder;
        IAttachmentDAO dao = this.getAttachmentDAO();
        for (AttachmentPE attachment : attachments) {
            try {
                actualAttachmentHolder = dao.createAttachment(attachment, actualAttachmentHolder);
            }
            catch (DataAccessException e) {
                String fileName = attachment.getFileName();
                AbstractBusinessObject.throwException(e, String.format("Filename '%s' for %s '%s'", fileName, attachmentHolder.getHolderName(), attachmentHolder.getIdentifier()));
            }
        }
        attachments.clear();
    }

    protected void saveAttachments(List<? extends AttachmentHolderPE> holders, List<List<AttachmentPE>> attachmentListsOrNull) {
        if (attachmentListsOrNull == null) {
            return;
        }
        int idx = 0;
        for (List<AttachmentPE> attachments : attachmentListsOrNull) {
            this.saveAttachment(holders.get(idx), attachments);
            ++idx;
        }
    }
}

