/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkPHYS
extends PngChunk {
    public long pixelsxUnitX;
    public long pixelsxUnitY;
    public int units;

    public PngChunkPHYS(ImageInfo info) {
        super("pHYs", info);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = this.createEmptyChunk(9, true);
        PngHelper.writeInt4tobytes((int)this.pixelsxUnitX, c.data, 0);
        PngHelper.writeInt4tobytes((int)this.pixelsxUnitY, c.data, 4);
        c.data[8] = (byte)this.units;
        return c;
    }

    public void parseFromChunk(ChunkRaw chunk) {
        if (chunk.len != 9) {
            throw new PngjException("bad chunk length " + chunk);
        }
        this.pixelsxUnitX = PngHelper.readInt4fromBytes(chunk.data, 0);
        if (this.pixelsxUnitX < 0L) {
            this.pixelsxUnitX += 0x100000000L;
        }
        this.pixelsxUnitY = PngHelper.readInt4fromBytes(chunk.data, 4);
        if (this.pixelsxUnitY < 0L) {
            this.pixelsxUnitY += 0x100000000L;
        }
        this.units = PngHelper.readInt1fromByte(chunk.data, 8);
    }

    public double getAsDpi() {
        if (this.units != 1 || this.pixelsxUnitX != this.pixelsxUnitY) {
            return -1.0;
        }
        return (double)this.pixelsxUnitX * 0.0254;
    }

    public void setAsDpi(double dpi) {
        this.units = 1;
        this.pixelsxUnitY = this.pixelsxUnitX = (long)(dpi / 0.0254 + 0.5);
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkPHYS otherx = (PngChunkPHYS)other;
        this.pixelsxUnitX = otherx.pixelsxUnitX;
        this.pixelsxUnitY = otherx.pixelsxUnitY;
        this.units = otherx.units;
    }
}

