/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dataset;
import ome.xml.model.DatasetRef;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.ExperimenterGroupRef;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Project
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Project.class);
    private String name;
    private String id;
    private String description;
    private Experimenter experimenter;
    private ExperimenterGroup experimenterGroup;
    private List<Dataset> datasetLinks = new ArrayList<Dataset>();
    private List<Annotation> annotationLinks = new ArrayList<Annotation>();

    public Project() {
    }

    public Project(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Project".equals(tagName)) {
            LOGGER.debug("Expecting node name of Project got {}", (Object)tagName);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Project missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = Project.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimenterRef_nodeList = Project.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenter_reference = new ExperimenterRef();
            experimenter_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenter_reference);
        }
        List<Element> ExperimenterGroupRef_nodeList = Project.getChildrenByTagName(element, "ExperimenterGroupRef");
        for (Element ExperimenterGroupRef_element : ExperimenterGroupRef_nodeList) {
            ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
            experimenterGroup_reference.setID(ExperimenterGroupRef_element.getAttribute("ID"));
            model.addReference(this, experimenterGroup_reference);
        }
        List<Element> DatasetRef_nodeList = Project.getChildrenByTagName(element, "DatasetRef");
        for (Element DatasetRef_element : DatasetRef_nodeList) {
            DatasetRef datasetLinks_reference = new DatasetRef();
            datasetLinks_reference.setID(DatasetRef_element.getAttribute("ID"));
            model.addReference(this, datasetLinks_reference);
        }
        List<Element> AnnotationRef_nodeList = Project.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkProject(this);
            this.experimenter = o_casted;
            return true;
        }
        if (reference instanceof ExperimenterGroupRef) {
            ExperimenterGroup o_casted = (ExperimenterGroup)o;
            o_casted.linkProject(this);
            this.experimenterGroup = o_casted;
            return true;
        }
        if (reference instanceof DatasetRef) {
            Dataset o_casted = (Dataset)o;
            o_casted.linkProject(this);
            if (!this.datasetLinks.contains(o_casted)) {
                this.datasetLinks.add(o_casted);
            }
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkProject(this);
            if (!this.annotationLinks.contains(o_casted)) {
                this.annotationLinks.add(o_casted);
            }
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public ExperimenterGroup getLinkedExperimenterGroup() {
        return this.experimenterGroup;
    }

    public void linkExperimenterGroup(ExperimenterGroup o) {
        this.experimenterGroup = o;
    }

    public void unlinkExperimenterGroup(ExperimenterGroup o) {
        if (this.experimenterGroup == o) {
            this.experimenterGroup = null;
        }
    }

    public int sizeOfLinkedDatasetList() {
        return this.datasetLinks.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.datasetLinks);
    }

    public Dataset getLinkedDataset(int index) {
        return this.datasetLinks.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.datasetLinks.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        o.linkProject(this);
        if (!this.datasetLinks.contains(o)) {
            return this.datasetLinks.add(o);
        }
        return false;
    }

    public boolean unlinkDataset(Dataset o) {
        o.unlinkProject(this);
        return this.datasetLinks.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkProject(this);
        if (!this.annotationLinks.contains(o)) {
            return this.annotationLinks.add(o);
        }
        return false;
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkProject(this);
        return this.annotationLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Project_element) {
        Reference o;
        Reference o2;
        if (Project_element == null) {
            Project_element = document.createElementNS(NAMESPACE, "Project");
        }
        if (this.name != null) {
            Project_element.setAttribute("Name", this.name.toString());
        }
        if (this.id != null) {
            Project_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Project_element.appendChild(description_element);
        }
        if (this.experimenter != null) {
            o2 = new ExperimenterRef();
            ((ExperimenterRef)o2).setID(this.experimenter.getID());
            Project_element.appendChild(((ExperimenterRef)o2).asXMLElement(document));
        }
        if (this.experimenterGroup != null) {
            o2 = new ExperimenterGroupRef();
            ((ExperimenterGroupRef)o2).setID(this.experimenterGroup.getID());
            Project_element.appendChild(((ExperimenterGroupRef)o2).asXMLElement(document));
        }
        if (this.datasetLinks != null) {
            for (Dataset datasetLinks_value : this.datasetLinks) {
                o = new DatasetRef();
                ((DatasetRef)o).setID(datasetLinks_value.getID());
                Project_element.appendChild(((DatasetRef)o).asXMLElement(document));
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                Project_element.appendChild(((AnnotationRef)o).asXMLElement(document));
            }
        }
        return super.asXMLElement(document, Project_element);
    }
}

