/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import thredds.catalog.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.trajectory.MultiTrajectoryObsDataset;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class Float10TrajectoryObsDataset
extends MultiTrajectoryObsDataset
implements TypedDatasetFactoryIF {
    private static String trajDimNameDefault = "DRIFTER100_110";
    private static String trajVarNameDefault = "DRIFTER100_110";
    private static String timeDimNameDefault = "TIME1";
    private static String timeVarNameDefault = "TIME1";
    private static String latVarNameDefault = "LATITUDE";
    private static String lonVarNameDefault = "LONGITUDE";
    private static String elevVarNameDefault = "DEPTH";
    private String trajDimName;
    private String trajVarName;
    private String timeDimName;
    private String timeVarName;
    private String latVarName;
    private String lonVarName;
    private String elevVarName;

    public static boolean isValidFile(NetcdfDataset ds) {
        int i;
        Dimension d;
        List<Dimension> list = ds.getRootGroup().getDimensions();
        if (list.size() != 2) {
            return false;
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            d = list.get(i2);
            if (d.getName().equals(timeDimNameDefault) || d.getName().equals(trajDimNameDefault)) continue;
            return false;
        }
        Variable var = ds.getRootGroup().findVariable(trajVarNameDefault);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = list.get(0);
        if (!d.getName().equals(trajDimNameDefault)) {
            return false;
        }
        var = ds.getRootGroup().findVariable(timeVarNameDefault);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = list.get(0);
        if (!d.getName().equals(timeDimNameDefault)) {
            return false;
        }
        String units = var.findAttribute("units").getStringValue();
        Date date = DateUnit.getStandardDate("0 " + units);
        if (date == null) {
            return false;
        }
        var = ds.getRootGroup().findVariable(latVarNameDefault);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            d = list.get(i);
            if (d.getName().equals(timeDimNameDefault) || d.getName().equals(trajDimNameDefault)) continue;
            return false;
        }
        var = ds.getRootGroup().findVariable(lonVarNameDefault);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            d = list.get(i);
            if (d.getName().equals(timeDimNameDefault) || d.getName().equals(trajDimNameDefault)) continue;
            return false;
        }
        var = ds.getRootGroup().findVariable(elevVarNameDefault);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            d = list.get(i);
            if (d.getName().equals(timeDimNameDefault) || d.getName().equals(trajDimNameDefault)) continue;
            return false;
        }
        units = var.findAttribute("units").getStringValue();
        return SimpleUnit.isCompatible(units, "m");
    }

    public boolean isMine(NetcdfDataset ds) {
        return Float10TrajectoryObsDataset.isValidFile(ds);
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuffer errlog) throws IOException {
        return new Float10TrajectoryObsDataset(ncd);
    }

    public DataType getScientificDataType() {
        return DataType.TRAJECTORY;
    }

    public Float10TrajectoryObsDataset() {
    }

    public Float10TrajectoryObsDataset(NetcdfDataset ncd) throws IOException {
        super(ncd);
        this.trajDimName = trajDimNameDefault;
        this.trajVarName = trajVarNameDefault;
        this.timeDimName = timeDimNameDefault;
        this.timeVarName = timeVarNameDefault;
        this.latVarName = latVarNameDefault;
        this.lonVarName = lonVarNameDefault;
        this.elevVarName = elevVarNameDefault;
        Variable latVar = ncd.getRootGroup().findVariable(this.latVarName);
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        Variable lonVar = ncd.getRootGroup().findVariable(this.lonVarName);
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        this.setTrajectoryInfo(this.ncfile.getRootGroup().findDimension(this.trajDimName), this.ncfile.getRootGroup().findVariable(this.trajVarName), this.ncfile.getRootGroup().findDimension(this.timeDimName), this.ncfile.getRootGroup().findVariable(this.timeVarName), this.ncfile.getRootGroup().findVariable(this.latVarName), this.ncfile.getRootGroup().findVariable(this.lonVarName), this.ncfile.getRootGroup().findVariable(this.elevVarName));
    }
}

