/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3iosp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class N3streamWriter {
    private NetcdfFile ncfile;
    private List vinfoList = new ArrayList();
    private boolean debugPos = false;
    private boolean debugWriteData = false;
    private int recStart;
    private int recSize;
    private long filePos = 0L;
    private int recno = 0;
    private boolean first = true;

    public N3streamWriter(NetcdfFile ncfile) {
        this.ncfile = ncfile;
    }

    public void writeHeader(DataOutputStream stream) throws IOException {
        Vinfo vinfo;
        Variable var;
        int i;
        int dataStart;
        this.ncfile.finish();
        stream.write(N3header.MAGIC);
        int count = N3header.MAGIC.length;
        Dimension udim = this.ncfile.getUnlimitedDimension();
        int numrec = udim == null ? 0 : -1;
        stream.writeInt(numrec);
        count += 4;
        List<Dimension> dims = this.ncfile.getDimensions();
        int numdims = dims.size();
        if (numdims == 0) {
            stream.writeInt(0);
            stream.writeInt(0);
        } else {
            stream.writeInt(10);
            stream.writeInt(numdims);
        }
        count += 8;
        for (int i2 = 0; i2 < numdims; ++i2) {
            Dimension dim = dims.get(i2);
            count += this.writeString(stream, dim.getName());
            stream.writeInt(dim.isUnlimited() ? 0 : dim.getLength());
            count += 4;
        }
        count += this.writeAtts(stream, this.ncfile.getGlobalAttributes());
        List<Variable> vars = this.ncfile.getVariables();
        int nvars = vars.size();
        if (nvars == 0) {
            stream.writeInt(0);
            stream.writeInt(0);
        } else {
            stream.writeInt(11);
            stream.writeInt(nvars);
        }
        count += 8;
        for (int i3 = 0; i3 < nvars; ++i3) {
            Variable var2 = vars.get(i3);
            if (var2 instanceof Structure) continue;
            Vinfo vinfo2 = this.writeVar(null, var2, 0);
            count += vinfo2.hsize;
        }
        int offset = dataStart = count;
        for (i = 0; i < nvars; ++i) {
            var = vars.get(i);
            if (var.isUnlimited()) continue;
            vinfo = this.writeVar(stream, var, offset);
            var.setSPobject(vinfo);
            if (this.debugPos) {
                System.out.println(" " + var.getNameAndDimensions() + " begin at = " + offset + " end=" + (offset + vinfo.vsize));
            }
            offset += vinfo.vsize;
            this.vinfoList.add(vinfo);
        }
        this.recStart = offset;
        this.recSize = 0;
        for (i = 0; i < nvars; ++i) {
            var = vars.get(i);
            if (!var.isUnlimited() || var instanceof Structure) continue;
            vinfo = this.writeVar(stream, var, offset);
            var.setSPobject(vinfo);
            if (this.debugPos) {
                System.out.println(" " + var.getNameAndDimensions() + "(record) begin at = " + offset + " end=" + (offset + vinfo.vsize) + " size=" + vinfo.vsize);
            }
            offset += vinfo.vsize;
            this.recSize += vinfo.vsize;
            this.vinfoList.add(vinfo);
        }
        this.filePos = count;
        if (this.debugPos) {
            System.out.println("header written filePos= " + this.filePos);
        }
    }

    private Vinfo writeVar(DataOutputStream stream, Variable var, int offset) throws IOException {
        int count = 0;
        count += this.writeString(stream, var.getName());
        int vsize = var.getDataType().getSize();
        List<Dimension> dims = var.getDimensions();
        if (null != stream) {
            stream.writeInt(dims.size());
        }
        count += 4;
        for (int j = 0; j < dims.size(); ++j) {
            Dimension dim = dims.get(j);
            int dimIndex = this.findDimensionIndex(dim);
            if (null != stream) {
                stream.writeInt(dimIndex);
            }
            count += 4;
            if (dim.isUnlimited()) continue;
            vsize *= dim.getLength();
        }
        int pad = N3header.padding(vsize);
        vsize += pad;
        count += this.writeAtts(stream, var.getAttributes());
        int type = N3header.getType(var.getDataType());
        if (null != stream) {
            stream.writeInt(type);
            stream.writeInt(vsize);
            stream.writeInt(offset);
        }
        return new Vinfo(var, count += 12, vsize, offset, pad, var.isUnlimited());
    }

    private int writeAtts(DataOutputStream stream, List<Attribute> atts) throws IOException {
        int natts = atts.size();
        if (null != stream) {
            if (natts == 0) {
                stream.writeInt(0);
                stream.writeInt(0);
            } else {
                stream.writeInt(12);
                stream.writeInt(natts);
            }
        }
        int count = 8;
        for (int i = 0; i < natts; ++i) {
            Attribute att = atts.get(i);
            count += this.writeString(stream, att.getName());
            int type = N3header.getType(att.getDataType());
            if (null != stream) {
                stream.writeInt(type);
            }
            count += 4;
            if (type == 2) {
                count += this.writeStringValues(stream, att);
                continue;
            }
            int nelems = att.getLength();
            if (null != stream) {
                stream.writeInt(nelems);
            }
            count += 4;
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.writeAttributeValue(stream, att.getNumericValue(j));
            }
            count += nbytes;
            count += this.pad(stream, nbytes, (byte)0);
        }
        return count;
    }

    private int writeStringValues(DataOutputStream stream, Attribute att) throws IOException {
        int n = att.getLength();
        if (n == 1) {
            return this.writeString(stream, att.getStringValue());
        }
        StringBuffer values = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            values.append(att.getStringValue(i));
        }
        return this.writeString(stream, values.toString());
    }

    private int writeAttributeValue(DataOutputStream stream, Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            if (null != stream) {
                stream.write(numValue.byteValue());
            }
            return 1;
        }
        if (numValue instanceof Short) {
            if (null != stream) {
                stream.writeShort(numValue.shortValue());
            }
            return 2;
        }
        if (numValue instanceof Integer) {
            if (null != stream) {
                stream.writeInt(numValue.intValue());
            }
            return 4;
        }
        if (numValue instanceof Float) {
            if (null != stream) {
                stream.writeFloat(numValue.floatValue());
            }
            return 4;
        }
        if (numValue instanceof Double) {
            if (null != stream) {
                stream.writeDouble(numValue.doubleValue());
            }
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private int writeString(DataOutputStream stream, String s) throws IOException {
        byte[] b = s.getBytes();
        if (null != stream) {
            stream.writeInt(b.length);
            stream.write(b);
        }
        int n = this.pad(stream, b.length, (byte)0);
        return n + 4 + b.length;
    }

    private int findDimensionIndex(Dimension wantDim) {
        List<Dimension> dims = this.ncfile.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (!dim.equals(wantDim)) continue;
            return i;
        }
        throw new IllegalStateException("unknown Dimension == " + wantDim);
    }

    private int pad(DataOutputStream stream, int nbytes, byte fill) throws IOException {
        int pad = N3header.padding(nbytes);
        if (null != stream) {
            for (int i = 0; i < pad; ++i) {
                stream.write(fill);
            }
        }
        return pad;
    }

    public void writeDataAll(DataOutputStream stream) throws IOException {
        for (int i = 0; i < this.vinfoList.size(); ++i) {
            Vinfo vinfo = (Vinfo)this.vinfoList.get(i);
            if (vinfo.isRecord) continue;
            Variable v = vinfo.v;
            this.writeDataFast(v, stream, v.read());
            this.pad(stream, vinfo.vsize, (byte)0);
        }
        boolean useRecordDimension = this.ncfile.hasUnlimitedDimension();
        if (useRecordDimension) {
            this.ncfile.sendIospMessage("AddRecordStructure");
        }
        if (useRecordDimension) {
            boolean first = true;
            Structure recordVar = (Structure)this.ncfile.findVariable("record");
            Structure.Iterator ii = recordVar.getStructureIterator();
            while (ii.hasNext()) {
                StructureData sdata = ii.next();
                int count = 0;
                for (int i = 0; i < this.vinfoList.size(); ++i) {
                    Vinfo vinfo = (Vinfo)this.vinfoList.get(i);
                    if (!vinfo.isRecord) continue;
                    Variable v = vinfo.v;
                    int nbytes = this.writeDataFast(v, stream, sdata.getArray(v.getName()));
                    count += nbytes;
                    count += this.pad(stream, nbytes, (byte)0);
                    if (!first || !this.debugWriteData) continue;
                    System.out.println(v.getName() + " wrote " + count + " bytes");
                }
                if (first && this.debugWriteData) {
                    System.out.println("wrote " + count + " bytes");
                }
                first = false;
            }
            this.ncfile.sendIospMessage("RemoveRecordStructure");
            this.ncfile.finish();
        }
    }

    public void writeNonRecordData(Variable v, DataOutputStream stream, Array data) throws IOException {
        Vinfo vinfo = (Vinfo)v.getSPobject();
        if (this.debugWriteData) {
            System.out.println("Write " + v.getName() + " at filePos= " + this.filePos + " vinfo.offset= " + vinfo.offset);
        }
        if (this.filePos != (long)vinfo.offset) {
            throw new IllegalStateException();
        }
        this.filePos += this.writeData(v, stream, data);
        if (vinfo.pad > 0) {
            byte[] dummy = new byte[vinfo.pad];
            stream.write(dummy);
            this.filePos += (long)vinfo.pad;
        }
    }

    public void writeRecordData(DataOutputStream stream, List<Variable> varList) throws IOException {
        long want = this.recStart + this.recno * this.recSize;
        if (this.debugWriteData) {
            System.out.println("Write record at filePos= " + this.filePos + " should be= " + want);
        }
        if (this.filePos != want) {
            throw new IllegalStateException();
        }
        for (Variable v : varList) {
            if (this.first && this.debugWriteData) {
                System.out.println("  write record var " + v.getNameAndDimensions());
            }
            this.filePos += this.writeData(v, stream, v.read());
            Vinfo vinfo = (Vinfo)v.getSPobject();
            if (vinfo.pad <= 0) continue;
            byte[] dummy = new byte[vinfo.pad];
            stream.write(dummy);
            this.filePos += (long)vinfo.pad;
        }
        this.first = false;
        ++this.recno;
    }

    private long writeData(Variable v, DataOutputStream stream, Array values) throws IOException {
        DataType dataType = v.getDataType();
        IndexIterator ii = values.getIndexIterator();
        if (dataType == DataType.BYTE) {
            while (ii.hasNext()) {
                stream.write(ii.getByteNext());
            }
            return values.getSize();
        }
        if (dataType == DataType.CHAR) {
            while (ii.hasNext()) {
                stream.write(ii.getByteNext());
            }
            return values.getSize();
        }
        if (dataType == DataType.SHORT) {
            while (ii.hasNext()) {
                stream.writeShort(ii.getShortNext());
            }
            return 2L * values.getSize();
        }
        if (dataType == DataType.INT) {
            while (ii.hasNext()) {
                stream.writeInt(ii.getIntNext());
            }
            return 4L * values.getSize();
        }
        if (dataType == DataType.FLOAT) {
            while (ii.hasNext()) {
                stream.writeFloat(ii.getFloatNext());
            }
            return 4L * values.getSize();
        }
        if (dataType == DataType.DOUBLE) {
            while (ii.hasNext()) {
                stream.writeDouble(ii.getDoubleNext());
            }
            return 8L * values.getSize();
        }
        throw new IllegalStateException("dataType= " + dataType);
    }

    private int writeDataFast(Variable v, DataOutputStream stream, Array values) throws IOException {
        DataType dataType = v.getDataType();
        if (dataType == DataType.BYTE) {
            byte[] pa = (byte[])values.get1DJavaArray(Byte.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.write(pa[i]);
            }
            return pa.length;
        }
        if (dataType == DataType.CHAR) {
            byte[] pa = N3iosp.convertCharToByte((char[])values.get1DJavaArray(Character.TYPE));
            for (int i = 0; i < pa.length; ++i) {
                stream.write(pa[i]);
            }
            return pa.length;
        }
        if (dataType == DataType.SHORT) {
            short[] pa = (short[])values.get1DJavaArray(Short.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeShort(pa[i]);
            }
            return 2 * pa.length;
        }
        if (dataType == DataType.INT) {
            int[] pa = (int[])values.get1DJavaArray(Integer.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeInt(pa[i]);
            }
            return 4 * pa.length;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])values.get1DJavaArray(Float.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeFloat(pa[i]);
            }
            return 4 * pa.length;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])values.get1DJavaArray(Double.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeDouble(pa[i]);
            }
            return 8 * pa.length;
        }
        throw new IllegalStateException("dataType= " + dataType);
    }

    public static void writeFromFile(NetcdfFile fileIn, String fileOutName) throws IOException {
        DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileOutName), 10000));
        N3streamWriter writer = new N3streamWriter(fileIn);
        writer.writeHeader(stream);
        writer.writeDataAll(stream);
        stream.close();
    }

    static class Vinfo {
        Variable v;
        int hsize;
        int vsize;
        int offset;
        int pad;
        boolean isRecord;

        Vinfo(Variable v, int hsize, int vsize, int offset, int pad, boolean isRecord) {
            this.v = v;
            this.hsize = hsize;
            this.vsize = vsize;
            this.offset = offset;
            this.pad = pad;
            this.isRecord = isRecord;
        }
    }
}

