/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.attachment;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.AttachmentVersionModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.ColumnConfigFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.attachment.AttachmentDownloadHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.attachment.AttachmentListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.AttachmentFileUploadField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.PopupDialogBasedInfoHandler;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IAttachmentHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentVersions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.CellSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AttachmentBrowser
extends TypedTableGrid<AttachmentVersions> {
    private static final String PREFIX = "attachment-browser_";
    private static final String ID_PREFIX = "openbis_attachment-browser_";
    public static final String DOWNLOAD_BUTTON_ID_SUFFIX = "_download-button";
    public static final String ADD_BUTTON_ID_SUFFIX = "_add-button";
    private final IDelegatedAction postRegistrationCallback;
    private final IAttachmentHolder attachmentHolder;
    private final String sessionKey;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, IAttachmentHolder attachmentHolder) {
        AttachmentBrowser browser = new AttachmentBrowser(viewContext, attachmentHolder);
        return browser.asDisposableWithoutToolbar();
    }

    public AttachmentBrowser(IViewContext<ICommonClientServiceAsync> viewContext, IAttachmentHolder attachmentHolder) {
        super(viewContext, AttachmentBrowser.createBrowserId(attachmentHolder), true, DisplayTypeIDGenerator.ATTACHMENT_BROWSER_GRID);
        this.sessionKey = AttachmentBrowser.createGridId(attachmentHolder);
        this.attachmentHolder = attachmentHolder;
        this.postRegistrationCallback = this.createRefreshGridAction();
        this.extendBottomToolbar();
        this.linkFile();
        this.linkVersions();
    }

    private void linkFile() {
        this.registerListenerAndLinkGeneratorForAnyMode("FILE_NAME", new ICellListenerAndLinkGenerator<AttachmentVersions>(){

            @Override
            public void handle(TableModelRowWithObject<AttachmentVersions> rowItem, boolean specialKeyPressed) {
                Attachment current = rowItem.getObjectOrNull().getCurrent();
                String fileName = current.getFileName();
                int version = current.getVersion();
                AttachmentDownloadHelper.download(fileName, version, AttachmentBrowser.this.attachmentHolder);
            }

            @Override
            public String tryGetLink(AttachmentVersions entity, ISerializableComparable comparableValue) {
                return "";
            }
        });
    }

    private void linkVersions() {
        this.registerListenerAndLinkGeneratorForAnyMode("VERSION", new ICellListenerAndLinkGenerator<AttachmentVersions>(){

            @Override
            public void handle(TableModelRowWithObject<AttachmentVersions> rowItem, boolean keyPressed) {
                String fileName = rowItem.getObjectOrNull().getCurrent().getFileName();
                List<Attachment> versions = rowItem.getObjectOrNull().getVersions();
                AttachmentBrowser.this.showVersionsPanel(fileName, versions, keyPressed);
            }

            @Override
            public String tryGetLink(AttachmentVersions entity, ISerializableComparable comparableValue) {
                return "";
            }
        });
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<AttachmentVersions>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<AttachmentVersions>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("PERMLINK", LinkRenderer.createExternalLinkRenderer(this.viewContext.getMessage("permlink_column_name", new Object[0])));
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        return schema;
    }

    private static String createGridId(IAttachmentHolder holder) {
        return AttachmentBrowser.createGridId(TechId.create(holder), holder.getAttachmentHolderKind());
    }

    private static String createBrowserId(IAttachmentHolder holder) {
        return AttachmentBrowser.createBrowserId(TechId.create(holder), holder.getAttachmentHolderKind());
    }

    public static String createGridId(TechId id, AttachmentHolderKind kind) {
        return String.valueOf(AttachmentBrowser.createBrowserId(id, kind)) + "-grid";
    }

    public static String createBrowserId(TechId id, AttachmentHolderKind kind) {
        return ID_PREFIX + kind.name() + "-" + id;
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add", this.viewContext.getMessage("attachment", new Object[0])), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                IDelegatedAction refreshGridAction = AttachmentBrowser.this.createRefreshGridAction();
                AddAttachmentDialog dialog = new AddAttachmentDialog(AttachmentBrowser.this.viewContext, AttachmentBrowser.this.sessionKey, AttachmentBrowser.this.attachmentHolder, refreshGridAction);
                dialog.show();
            }
        });
        addButton.setId(String.valueOf(AttachmentBrowser.createBrowserId(this.attachmentHolder)) + ADD_BUTTON_ID_SUFFIX);
        this.addButton(addButton);
        String downloadTitle = this.viewContext.getMessage("button_download", new Object[0]);
        Button downloadButton = this.createSelectedItemButton(downloadTitle, this.asDownloadAttachmentInvoker());
        downloadButton.setId(String.valueOf(AttachmentBrowser.createBrowserId(this.attachmentHolder)) + DOWNLOAD_BUTTON_ID_SUFFIX);
        this.addButton(downloadButton);
        String showAllVersionsTitle = this.viewContext.getMessage("button_show_all_versions", new Object[0]);
        Button showAllVersionsButton = this.createSelectedItemButton(showAllVersionsTitle, this.asShowEntityInvoker(false));
        this.addButton(showAllVersionsButton);
        if (!this.viewContext.isSimpleOrEmbeddedMode()) {
            this.addButton(this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<AttachmentVersions>>>(){

                @Override
                public void invoke(BaseEntityModel<TableModelRowWithObject<AttachmentVersions>> selectedItem, boolean keyPressed) {
                    AttachmentVersions versions = selectedItem.getBaseObject().getObjectOrNull();
                    AttachmentBrowser.this.createEditAttachmentDialog(versions).show();
                }
            }));
            this.addButton(this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

                protected Dialog createDialog(List<TableModelRowWithObject<AttachmentVersions>> attachmentVersions, IBrowserGridActionInvoker invoker) {
                    return new AttachmentListDeletionConfirmationDialog(AttachmentBrowser.this.viewContext, attachmentVersions, AttachmentBrowser.this.createRefreshCallback(invoker), AttachmentBrowser.this.attachmentHolder);
                }
            }));
        }
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    protected final TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<AttachmentVersions>>> asDownloadAttachmentInvoker() {
        return new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<AttachmentVersions>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<AttachmentVersions>> selectedItem, boolean keyPressed) {
                AttachmentVersions versions = selectedItem.getBaseObject().getObjectOrNull();
                String fileName = versions.getCurrent().getFileName();
                int version = versions.getCurrent().getVersion();
                AttachmentDownloadHelper.download(fileName, version, AttachmentBrowser.this.attachmentHolder);
            }
        };
    }

    private Window createEditAttachmentDialog(AttachmentVersions versions) {
        final Attachment current = versions.getCurrent();
        String title = this.viewContext.getMessage("edit_title", "Attachment", "'" + current.getFileName() + "'");
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            private final TextField<String> titleField;
            private final DescriptionField descriptionField;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.titleField = 7.createTextField(AttachmentBrowser.this.viewContext.getMessage("title", new Object[0]));
                FieldUtil.setValueWithUnescaping(this.titleField, attachment.getTitle());
                this.addField((Widget)this.titleField);
                this.descriptionField = 7.createDescriptionField(AttachmentBrowser.this.viewContext);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, attachment.getDescription());
                this.addField((Widget)this.descriptionField);
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                current.setTitle((String)this.titleField.getValue());
                current.setDescription((String)this.descriptionField.getValue());
                ((ICommonClientServiceAsync)AttachmentBrowser.this.viewContext.getService()).updateAttachment(TechId.create(AttachmentBrowser.this.attachmentHolder), AttachmentBrowser.this.attachmentHolder.getAttachmentHolderKind(), current, registrationCallback);
            }
        };
    }

    @Override
    protected void showEntityViewer(TableModelRowWithObject<AttachmentVersions> entity, boolean editMode, boolean inBackground) {
        assert (!editMode) : "edit mode is not implemented";
        String fileName = entity.getObjectOrNull().getCurrent().getFileName();
        List<Attachment> versions = entity.getObjectOrNull().getVersions();
        this.showVersionsPanel(fileName, versions, inBackground);
    }

    private void showVersionsPanel(String fileName, final List<Attachment> versions, boolean inBackground) {
        assert (versions != null) : "versions not set!";
        final VersionsPanelHelper helper = new VersionsPanelHelper(fileName, this.attachmentHolder, this.viewContext);
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                ContentPanel component = helper.createVersionsPanel(versions);
                return DefaultTabItem.createUnaware(this.getTabTitle(), (Component)component, false, AttachmentBrowser.this.viewContext);
            }

            @Override
            public String getId() {
                return helper.createTabId();
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ATTACHMENTS, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String getTabTitle() {
                return helper.createTabTitle();
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        tabFactory.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.equals("PERMLINK") ? "permlink_column_name" : columnID.toLowerCase();
    }

    @Override
    protected BaseEntityModel<TableModelRowWithObject<AttachmentVersions>> createModel(GridRowModel<TableModelRowWithObject<AttachmentVersions>> entity) {
        BaseEntityModel<TableModelRowWithObject<AttachmentVersions>> model = super.createModel(entity);
        this.renderVersionAsLink((ModelData)model);
        return model;
    }

    private void renderVersionAsLink(ModelData model) {
        String versionId = "VERSION";
        String originalValue = (String)model.get(versionId);
        String linkText = this.viewContext.getMessage("show_all_versions", new Object[0]);
        model.set(versionId, (Object)(String.valueOf(originalValue) + " (" + linkText + ")"));
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<AttachmentVersions>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<AttachmentVersions>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listAttachmentVersions(TechId.create(this.attachmentHolder), this.attachmentHolder.getAttachmentHolderKind(), resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<AttachmentVersions>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportAttachmentVersions(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.edit(this.getObjectKind())};
    }

    private DatabaseModificationKind.ObjectKind getObjectKind() {
        return DatabaseModificationKind.ObjectKind.valueOf(this.attachmentHolder.getAttachmentHolderKind().toString());
    }

    private static class AddAttachmentDialog
    extends AbstractRegistrationDialog {
        private AttachmentFileUploadField attachmentFileUploadField;
        private final IViewContext<?> viewContext;
        private final IAttachmentHolder attachmentHolder;
        private final String sessionKey;
        private AsyncCallback<Void> registrationCallback;

        AddAttachmentDialog(IViewContext<?> viewContext, String sessionKey, IAttachmentHolder attachmentHolder, IDelegatedAction postRegistrationCallback) {
            super(viewContext, viewContext.getMessage("add_attachment_title", new Object[0]), postRegistrationCallback);
            this.viewContext = viewContext;
            this.sessionKey = sessionKey;
            this.attachmentHolder = attachmentHolder;
            this.attachmentFileUploadField = new AttachmentFileUploadField(viewContext);
            this.attachmentFileUploadField.addFieldsTo(this.form, sessionKey, viewContext);
            AbstractRegistrationForm.addFileUploadFeature(this.form, Arrays.asList(sessionKey));
            this.form.addListener(Events.Submit, new FormPanelListener(new PopupDialogBasedInfoHandler(viewContext)){

                @Override
                protected void setUploadEnabled() {
                }

                @Override
                protected void onSuccessfullUpload() {
                    AddAttachmentDialog.this.registerAfterSubmit();
                }
            });
        }

        @Override
        protected void register(AsyncCallback<Void> callBack) {
            this.registrationCallback = callBack;
            this.form.submit();
        }

        private void registerAfterSubmit() {
            ICommonClientServiceAsync service = this.viewContext.getCommonService();
            TechId holderId = TechId.create(this.attachmentHolder);
            AttachmentHolderKind holderKind = this.attachmentHolder.getAttachmentHolderKind();
            NewAttachment attachment = this.attachmentFileUploadField.tryExtractAttachment();
            service.addAttachment(holderId, this.sessionKey, holderKind, attachment, this.registrationCallback);
        }
    }

    private static final class VersionsPanelHelper {
        private final String fileName;
        private final IAttachmentHolder attachmentHolder;
        private final IMessageProvider messageProvider;

        public VersionsPanelHelper(String fileName, IAttachmentHolder attachmentHolder, IMessageProvider messageProvider) {
            this.fileName = fileName;
            this.attachmentHolder = attachmentHolder;
            this.messageProvider = messageProvider;
        }

        public ContentPanel createVersionsPanel(List<Attachment> oldVersions) {
            ContentPanel panel = new ContentPanel();
            panel.setHeading("Versions of file '" + this.fileName + "' from " + this.attachmentHolder.getAttachmentHolderKind().name().toLowerCase() + " '" + this.attachmentHolder.getCode() + "'");
            panel.setLayout((Layout)new FitLayout());
            ListStore attachmentStore = new ListStore();
            attachmentStore.add(AttachmentVersionModel.convert(oldVersions));
            final Grid attachmentGrid = new Grid(attachmentStore, new ColumnModel(this.defineAttachmentVersionsColumns()));
            CellSelectionModel selectionModel = new CellSelectionModel();
            attachmentGrid.setSelectionModel((GridSelectionModel)selectionModel);
            selectionModel.bindGrid(attachmentGrid);
            attachmentGrid.addListener(Events.CellClick, (Listener)new Listener<GridEvent<AttachmentVersionModel>>(){

                public void handleEvent(GridEvent<AttachmentVersionModel> be) {
                    if (ColumnListener.isLinkTarget(be)) {
                        String column = attachmentGrid.getColumnModel().getColumn(be.getColIndex()).getId();
                        if ("versionsFileName".equals(column)) {
                            AttachmentVersionModel selectedItem = (AttachmentVersionModel)be.getGrid().getStore().getAt(be.getRowIndex());
                            Attachment selectedAttachment = (Attachment)selectedItem.get("object");
                            int version = selectedAttachment.getVersion();
                            AttachmentDownloadHelper.download(VersionsPanelHelper.this.fileName, version, VersionsPanelHelper.this.attachmentHolder);
                        }
                        attachmentGrid.getSelectionModel().deselectAll();
                    }
                }
            });
            panel.setId(this.createTabId());
            panel.add((Widget)attachmentGrid);
            return panel;
        }

        public String createTabId() {
            return "openbis_attachment-versions-" + this.attachmentHolder.getId() + "_" + this.fileName;
        }

        public String createTabTitle() {
            return "Attachment " + this.attachmentHolder.getCode() + "/" + this.fileName;
        }

        private List<ColumnConfig> defineAttachmentVersionsColumns() {
            ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
            columns.add(this.createVersionFileNameColumn());
            columns.add(this.createPermlinkColumn());
            columns.add(ColumnConfigFactory.createRegistrationDateColumnConfig(this.messageProvider));
            columns.add(ColumnConfigFactory.createRegistratorColumnConfig(this.messageProvider));
            return columns;
        }

        private ColumnConfig createVersionFileNameColumn() {
            ColumnConfig column = ColumnConfigFactory.createDefaultColumnConfig(this.messageProvider.getMessage("version_file_name", new Object[0]), "versionsFileName");
            column.setWidth(200);
            column.setRenderer((GridCellRenderer)new GridCellRenderer<AttachmentVersionModel>(){

                public Object render(AttachmentVersionModel model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<AttachmentVersionModel> store, Grid<AttachmentVersionModel> grid) {
                    Object value = model.get(property);
                    if (value == null) {
                        return "";
                    }
                    return LinkRenderer.renderAsLinkWithAnchor((String)value);
                }
            });
            return column;
        }

        private ColumnConfig createPermlinkColumn() {
            ColumnConfig column = ColumnConfigFactory.createDefaultColumnConfig(this.messageProvider.getMessage("permlink_column_name", new Object[0]), "permlink");
            column.setWidth(100);
            column.setRenderer((GridCellRenderer)new GridCellRenderer<AttachmentVersionModel>(){

                public Object render(AttachmentVersionModel model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<AttachmentVersionModel> store, Grid<AttachmentVersionModel> grid) {
                    String url = StringEscapeUtils.unescapeHtml(StringUtils.toStringEmptyIfNull(model.get(property)));
                    return LinkRenderer.renderAsLinkWithAnchor(VersionsPanelHelper.this.messageProvider.getMessage("permlink_column_name", new Object[0]), url, true);
                }
            });
            return column;
        }
    }
}

