/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.VoidAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.WidgetTreeGridCellRenderer;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class ProjectSelectionTreeGridContainer
extends LayoutContainer
implements IDisposableComponent {
    public static final String ID = "openbis_select-project";
    private final IViewContext<?> viewContext;
    private final String initialSpaceCodeOrNull;
    private final String initialProjectIdentifierOrNull;
    private Project selectedProjectOrNull;
    private Space selectedSpaceOrNull;
    private SelectionChangedListener<?> selectionChangedListener;
    private Widget selectedProjectLinkOrNull;
    private final TreeGrid<ModelData> tree;
    private final Map<Project, Widget> projectLinks = new HashMap<Project, Widget>();
    private String resultSetKey;
    private ContentPanel contentPanel;
    public static final String PROJECT_WITH_SPACE_CODE = "projectWithSpaceCode";

    public ProjectSelectionTreeGridContainer(IViewContext<?> viewContext, String initialSpaceCodeOrNull, String initialProjectIdentifierOrNull) {
        super((Layout)new FitLayout());
        this.viewContext = viewContext;
        this.initialSpaceCodeOrNull = initialSpaceCodeOrNull;
        this.initialProjectIdentifierOrNull = initialProjectIdentifierOrNull;
        ColumnConfig codeColumn = this.createCodeColumn();
        ColumnModel columnModel = new ColumnModel(Arrays.asList(codeColumn));
        this.tree = this.createTreeGrid(columnModel);
        this.contentPanel = new ContentPanel();
        this.contentPanel.setBodyBorder(false);
        this.contentPanel.setHeading(viewContext.getMessage("project_selector_title", new Object[0]));
        this.contentPanel.setLayout((Layout)new FitLayout());
        this.contentPanel.add(this.tree);
        this.add((Component)this.contentPanel);
        this.refreshTree();
    }

    public ProjectSelectionTreeGridContainer(IViewContext<?> viewContext) {
        this(viewContext, null, null);
    }

    private TreeGrid<ModelData> createTreeGrid(ColumnModel columnModel) {
        TreeGrid treeGrid = new TreeGrid(new TreeStore(), columnModel);
        treeGrid.setLazyRowRender(0);
        treeGrid.setId(ID);
        treeGrid.setBorders(true);
        treeGrid.setAutoExpandColumn("code");
        treeGrid.getTreeView().setForceFit(true);
        treeGrid.getTreeView().setSortingEnabled(false);
        treeGrid.getTreeView().setBufferEnabled(false);
        GWTUtils.setToolTip((Component)treeGrid, this.viewContext.getMessage("project_selector_tooltip", new Object[0]));
        treeGrid.getStyle().setNodeCloseIcon(null);
        treeGrid.getStyle().setNodeOpenIcon(null);
        treeGrid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        treeGrid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<ModelData>(){

            public void selectionChanged(SelectionChangedEvent<ModelData> se) {
                ModelData selected;
                if (ProjectSelectionTreeGridContainer.this.selectedProjectOrNull != null) {
                    ProjectSelectionTreeGridContainer.this.selectedProjectLinkOrNull.setVisible(false);
                    ProjectSelectionTreeGridContainer.this.selectedProjectLinkOrNull = null;
                    ProjectSelectionTreeGridContainer.this.selectedProjectOrNull = null;
                }
                if (ProjectSelectionTreeGridContainer.this.selectedSpaceOrNull != null) {
                    ProjectSelectionTreeGridContainer.this.selectedSpaceOrNull = null;
                }
                if ((selected = se.getSelectedItem()) != null) {
                    if (ProjectSelectionTreeGridContainer.this.tree.isLeaf(selected)) {
                        ProjectSelectionTreeGridContainer.this.selectedProjectOrNull = (Project)selected.get("object");
                        ProjectSelectionTreeGridContainer.this.getSelectionChangedListener().handleEvent(null);
                        ProjectSelectionTreeGridContainer.this.selectedProjectLinkOrNull = (Widget)ProjectSelectionTreeGridContainer.this.projectLinks.get(ProjectSelectionTreeGridContainer.this.selectedProjectOrNull);
                        if (ProjectSelectionTreeGridContainer.this.selectedProjectLinkOrNull != null) {
                            ProjectSelectionTreeGridContainer.this.selectedProjectLinkOrNull.setVisible(true);
                        }
                    } else {
                        ProjectSelectionTreeGridContainer.this.selectedSpaceOrNull = (Space)selected.get("object");
                        ProjectSelectionTreeGridContainer.this.getSelectionChangedListener().handleEvent(null);
                    }
                }
            }
        });
        return treeGrid;
    }

    private ColumnConfig createCodeColumn() {
        ColumnConfig columnConfig = new ColumnConfig("code", this.viewContext.getMessage("project_selector_code_column", new Object[0]), 1);
        columnConfig.setRenderer((GridCellRenderer)new WidgetTreeGridCellRenderer<ModelData>(){
            final String projectSelectorDetailsLinkLabel;
            final String projectSelectorDetailsLinkTooltip;
            final String projectSelectorDescriptionNotAvailable;
            final String spaceMessage;
            {
                this.projectSelectorDetailsLinkLabel = ProjectSelectionTreeGridContainer.this.viewContext.getMessage("project_selector_details_link_label", new Object[0]);
                this.projectSelectorDetailsLinkTooltip = ProjectSelectionTreeGridContainer.this.viewContext.getMessage("project_selector_details_link_tooltip", new Object[0]);
                this.projectSelectorDescriptionNotAvailable = ProjectSelectionTreeGridContainer.this.viewContext.getMessage("project_selector_description_not_available", new Object[0]);
                this.spaceMessage = ProjectSelectionTreeGridContainer.this.viewContext.getMessage("space", new Object[0]);
            }

            public Widget getWidget(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ModelData> store, Grid<ModelData> grid) {
                if (model instanceof SpaceItemModel) {
                    return this.createSpaceWidget((SpaceItemModel)model);
                }
                if (model instanceof ProjectItemModel) {
                    return this.createProjectWidget((ProjectItemModel)model);
                }
                throw new UnsupportedOperationException("unsupported data model");
            }

            private Widget createSpaceWidget(SpaceItemModel model) {
                Space space = (Space)model.get("object");
                InlineHTML result = new InlineHTML(space.getCode());
                result.setTitle(this.createTooltipText(this.spaceMessage, space.getCode(), space.getDescription()));
                return result;
            }

            private Widget createProjectWidget(ProjectItemModel model) {
                final Project project = (Project)model.get("object");
                final String href = LinkExtractor.tryExtract(project);
                ClickHandler listener = new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        OpenEntityDetailsTabHelper.open(ProjectSelectionTreeGridContainer.this.viewContext, project, WidgetUtils.ifSpecialKeyPressed(event.getNativeEvent()), href);
                    }
                };
                Widget detailsLink = LinkRenderer.getLinkWidget(this.projectSelectorDetailsLinkLabel, listener, href);
                detailsLink.setTitle(this.projectSelectorDetailsLinkTooltip);
                ProjectSelectionTreeGridContainer.this.projectLinks.put(project, detailsLink);
                FlowPanelWithLinkAppearingOnMouseOver panel = new FlowPanelWithLinkAppearingOnMouseOver(project, detailsLink);
                panel.setTitle(this.createTooltipText("Project", project.getCode(), project.getDescription()));
                panel.add((Widget)new InlineHTML(String.valueOf(project.getCode()) + " "));
                panel.add(detailsLink);
                return panel;
            }

            private String createTooltipText(String entity, String code, String descriptionOrNull) {
                String description = descriptionOrNull == null ? this.projectSelectorDescriptionNotAvailable : StringEscapeUtils.unescapeHtml(descriptionOrNull);
                return String.valueOf(entity) + " code: " + code + "\nDescription: " + description;
            }

            class FlowPanelWithLinkAppearingOnMouseOver
            extends FlowPanel {
                private final Project project;
                private final Widget link;

                public FlowPanelWithLinkAppearingOnMouseOver(Project project, Widget link) {
                    this.project = project;
                    this.link = link;
                    this.sinkEvents(48);
                    if (!this.isProjectSelected()) {
                        link.setVisible(false);
                    }
                }

                private boolean isProjectSelected() {
                    return this.project.equals(ProjectSelectionTreeGridContainer.this.selectedProjectOrNull);
                }

                public void onBrowserEvent(Event event) {
                    switch (DOM.eventGetType((Event)event)) {
                        case 16: 
                        case 32: {
                            Element related;
                            Element element = related = event != null ? event.getRelatedTarget() : null;
                            if (related != null && this.getElement().isOrHasChild((Node)related)) {
                                return;
                            }
                            if (this.isProjectSelected()) break;
                            this.link.setVisible(DOM.eventGetType((Event)event) == 16);
                        }
                    }
                    DomEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this, (Element)this.getElement());
                }
            }
        });
        columnConfig.setMenuDisabled(true);
        columnConfig.setSortable(true);
        return columnConfig;
    }

    public final Project tryGetSelectedProject() {
        return this.selectedProjectOrNull;
    }

    public final Space tryGetSelectedSpace() {
        return this.selectedSpaceOrNull;
    }

    private SelectionChangedListener<?> getSelectionChangedListener() {
        return this.selectionChangedListener;
    }

    public void setSelectionChangedListener(SelectionChangedListener<?> listener) {
        this.selectionChangedListener = listener;
    }

    private void clearTree() {
        this.projectLinks.clear();
        this.tree.getTreeStore().removeAll();
    }

    private void rebuildTree(List<Project> projects) {
        this.clearTree();
        this.addToStore(projects);
        this.tree.expandAll();
    }

    private void addToStore(List<Project> projects) {
        SpaceItemModel spaceModel;
        Set<Space> spaces = this.getSortedSpaces(projects);
        HashMap<Space, SpaceItemModel> spaceToModelMap = new HashMap<Space, SpaceItemModel>();
        ArrayList<SpaceItemModel> spaceModels = new ArrayList<SpaceItemModel>(spaces.size());
        for (Space space : spaces) {
            spaceModel = new SpaceItemModel(space);
            spaceModels.add(spaceModel);
            spaceToModelMap.put(space, spaceModel);
        }
        this.tree.getTreeStore().add(spaceModels, true);
        for (Project project : projects) {
            spaceModel = (ModelData)spaceToModelMap.get(project.getSpace());
            this.tree.setLeaf((ModelData)spaceModel, false);
            ProjectItemModel projectModel = new ProjectItemModel(project);
            this.tree.getTreeStore().add((ModelData)spaceModel, (ModelData)projectModel, false);
            this.tree.setLeaf((ModelData)projectModel, true);
        }
    }

    private Set<Space> getSortedSpaces(List<Project> projects) {
        TreeSet<Space> spaces = new TreeSet<Space>();
        for (Project project : projects) {
            spaces.add(project.getSpace());
        }
        return spaces;
    }

    public void refreshTree() {
        this.loadData();
    }

    private void loadData() {
        this.viewContext.getCommonService().listProjectsForTree(new ListProjectsCallback(this.viewContext));
    }

    private void selectByProjectIdentifierIfPossible(String projectIdentifier) {
        GWTUtils.setSelectedItem(this.tree, "projectIdentifier", projectIdentifier);
    }

    private void selectBySpaceCodeIfPossible(String spaceCode) {
        GWTUtils.setSelectedItem(this.tree, "code", spaceCode);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROJECT);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.refreshTree();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        if (this.resultSetKey != null) {
            this.viewContext.getCommonService().removeResultSet(this.resultSetKey, new VoidAsyncCallback<Void>(this.viewContext));
        }
    }

    private static class BaseModelDataWithCode
    extends SimplifiedBaseModelData {
        private static final long serialVersionUID = 1L;

        public BaseModelDataWithCode(ICodeHolder codeProvider) {
            this.set("code", codeProvider.getCode());
            this.set("object", codeProvider);
        }

        public String toString() {
            return (String)this.get("code");
        }
    }

    private final class ListProjectsCallback
    extends AbstractAsyncCallback<List<Project>> {
        ListProjectsCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(List<Project> projects) {
            ProjectSelectionTreeGridContainer.this.rebuildTree(projects);
            String projectIdentifierOrNull = this.tryGetProjectIdentifierToSelect();
            if (projectIdentifierOrNull != null) {
                ProjectSelectionTreeGridContainer.this.selectByProjectIdentifierIfPossible(projectIdentifierOrNull);
            } else {
                String spaceCodeOrNull = this.tryGetSpaceCodeToSelect();
                if (spaceCodeOrNull != null) {
                    ProjectSelectionTreeGridContainer.this.selectBySpaceCodeIfPossible(spaceCodeOrNull);
                }
            }
        }

        private String tryGetProjectIdentifierToSelect() {
            return ProjectSelectionTreeGridContainer.this.selectedProjectOrNull != null ? ProjectSelectionTreeGridContainer.this.selectedProjectOrNull.getIdentifier() : ProjectSelectionTreeGridContainer.this.initialProjectIdentifierOrNull;
        }

        private String tryGetSpaceCodeToSelect() {
            return ProjectSelectionTreeGridContainer.this.selectedSpaceOrNull != null ? ProjectSelectionTreeGridContainer.this.selectedSpaceOrNull.getCode() : ProjectSelectionTreeGridContainer.this.initialSpaceCodeOrNull;
        }
    }

    private static class ProjectItemModel
    extends BaseModelDataWithCode {
        private static final long serialVersionUID = 1L;

        public ProjectItemModel(Project project) {
            super(project);
            this.set("projectIdentifier", project.getIdentifier());
            this.set(ProjectSelectionTreeGridContainer.PROJECT_WITH_SPACE_CODE, ProjectItemModel.getProjectWithSpaceCode(project));
        }

        private static String getProjectWithSpaceCode(Project project) {
            return String.valueOf(project.getCode()) + " (" + project.getSpace().getCode() + ")";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProjectItemModel)) {
                return false;
            }
            ProjectItemModel that = (ProjectItemModel)((Object)obj);
            return this.getIdentifier().equals(that.getIdentifier());
        }

        private String getIdentifier() {
            return (String)this.get("projectIdentifier");
        }

        public int hashCode() {
            return this.getIdentifier().hashCode();
        }
    }

    private static class SpaceItemModel
    extends BaseModelDataWithCode {
        private static final long serialVersionUID = 1L;

        public SpaceItemModel(Space space) {
            super(space);
            this.set("code", space.getCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SpaceItemModel)) {
                return false;
            }
            SpaceItemModel that = (SpaceItemModel)((Object)obj);
            return this.getCode().equals(that.getCode());
        }

        private String getCode() {
            return (String)this.get("code");
        }

        public int hashCode() {
            return this.getCode().hashCode();
        }
    }
}

