/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.logging.ControlFileBasedLogConfiguration;

public class LongRunningThreadLogConfiguration {
    static final String LONG_RUNNING_THREAD_LOGGING = "long-running-thread-logging";
    static final String LONG_RUNNING_THREAD_LOGGING_INTERVAL = "long-running-thread-logging-interval";
    static final String LONG_RUNNING_THREAD_ALERT_THRESHOLD = "long-running-thread-alert-threshold";
    private static final LongRunningThreadLogConfiguration instance = new LongRunningThreadLogConfiguration();
    private ControlFileBasedLogConfiguration config;

    LongRunningThreadLogConfiguration() {
        this(new ControlFileBasedLogConfiguration());
    }

    LongRunningThreadLogConfiguration(ControlFileBasedLogConfiguration config) {
        this.config = config;
        this.config.addBooleanParameter(LONG_RUNNING_THREAD_LOGGING, true);
        this.config.addLongParameter(LONG_RUNNING_THREAD_LOGGING_INTERVAL, 60000L);
        this.config.addLongParameter(LONG_RUNNING_THREAD_ALERT_THRESHOLD, 15000L);
    }

    public boolean isLoggingEnabled() {
        return this.config.getBooleanParameterValue(LONG_RUNNING_THREAD_LOGGING);
    }

    public long logInterval() {
        return this.config.getLongParameterValue(LONG_RUNNING_THREAD_LOGGING_INTERVAL);
    }

    public long maxValidInvocationLength() {
        return this.config.getLongParameterValue(LONG_RUNNING_THREAD_ALERT_THRESHOLD);
    }

    public static LongRunningThreadLogConfiguration getInstance() {
        return instance;
    }
}

