/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.calculator;

import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.customcolumn.core.CustomColumnMethod;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.customcolumn.extension.link.CustomColumnLinkParam;
import ch.systemsx.cisd.openbis.generic.shared.calculator.customcolumn.CustomColumnJSONBuilder;
import ch.systemsx.cisd.openbis.generic.shared.calculator.customcolumn.CustomColumnJSONServerData;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.InputSource;

public final class StandardFunctions {
    static final Double DOUBLE_DEFAULT_VALUE = Double.NaN;
    static final Integer INTEGER_DEFAULT_VALUE = new Integer(Integer.MIN_VALUE);
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public static boolean matches(String regex, String string) {
        return Pattern.matches(regex, string);
    }

    public static String evalXPath(String xPath, String xmlString) {
        try {
            XPathExpression expression = XPATH.compile(xPath);
            String str = StringEscapeUtils.unescapeXml((String)xmlString);
            String result = expression.evaluate(new InputSource(new StringReader(str)));
            return result;
        }
        catch (XPathExpressionException ex) {
            return "ERROR " + ExceptionUtils.getEndOfChain(ex).toString();
        }
    }

    public static Integer toInt(Object value) {
        return StandardFunctions.toInt(value, INTEGER_DEFAULT_VALUE);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return StandardFunctions.isBlank(value) ? defaultValue : new Integer(value.toString());
    }

    public static Double toFloat(Object value) {
        return StandardFunctions.toFloat(value, DOUBLE_DEFAULT_VALUE);
    }

    public static Double toFloat(Object value, Double defaultValue) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return StandardFunctions.isBlank(value) ? defaultValue : new Double(value.toString());
    }

    public static Object choose(Boolean condition, Object thenValue, Object elseValue) {
        return condition != null && condition != false ? thenValue : elseValue;
    }

    public static Double sum(List<Object> values) {
        List<Double> array = StandardFunctions.toDoubleArray(values);
        String functionName = "sum";
        StandardFunctions.assertNotEmpty(array, functionName);
        double sum = 0.0;
        for (double value : array) {
            sum += value;
        }
        return sum;
    }

    public static Double avg(List<Object> values) {
        List<Double> array = StandardFunctions.toDoubleArray(values);
        StandardFunctions.assertNotEmpty(array, "avg");
        double sum = 0.0;
        for (double value : array) {
            sum += value;
        }
        return sum / (double)array.size();
    }

    public static Double stdev(List<Object> values) {
        List<Double> array = StandardFunctions.toDoubleArray(values);
        StandardFunctions.assertNotEmpty(array, "stdev");
        double s1 = 0.0;
        double s2 = 0.0;
        for (double value : array) {
            s1 += value;
            s2 += value * value;
        }
        int n = array.size();
        double m1 = s1 / (double)n;
        double m2 = s2 / (double)n;
        return Math.sqrt(Math.max(0.0, m2 - m1 * m1));
    }

    public static Double median(List<Object> values) {
        List<Double> array = StandardFunctions.toDoubleArray(values);
        StandardFunctions.assertNotEmpty(array, "median");
        Collections.sort(array);
        int i = array.size() / 2;
        return array.size() % 2 == 0 ? (array.get(i - 1) + array.get(i)) / 2.0 : array.get(i);
    }

    public static Double min(List<Object> values) {
        List<Double> array = StandardFunctions.toDoubleArray(values);
        StandardFunctions.assertNotEmpty(array, "min");
        Collections.sort(array);
        return array.get(0);
    }

    public static Double max(List<Object> values) {
        List<Double> array = StandardFunctions.toDoubleArray(values);
        StandardFunctions.assertNotEmpty(array, "max");
        Collections.sort(array);
        return array.get(array.size() - 1);
    }

    public static Double sumOrDefault(List<Object> values, Double defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return StandardFunctions.sum(values);
    }

    public static Double avgOrDefault(List<Object> values, Double defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return StandardFunctions.avg(values);
    }

    public static Double stdevOrDefault(List<Object> values, Double defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return StandardFunctions.stdev(values);
    }

    public static Double medianOrDefault(List<Object> values, Double defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return StandardFunctions.median(values);
    }

    public static Double minOrDefault(List<Object> values, Double defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return StandardFunctions.min(values);
    }

    public static Double maxOrDefault(List<Object> values, Double defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return StandardFunctions.max(values);
    }

    public static Date currentDate() {
        return new Date();
    }

    public static String getDateAsString(Date date) {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return d.format(date);
    }

    public static String createLink(String linkText, String linkUrl) {
        CustomColumnJSONServerData data = new CustomColumnJSONServerData(CustomColumnMethod.LINK);
        data.addParam(CustomColumnLinkParam.LINK_TEXT.name(), linkText);
        data.addParam(CustomColumnLinkParam.LINK_URL.name(), linkUrl);
        return CustomColumnJSONBuilder.build(data);
    }

    private static boolean isBlank(Object value) {
        return value == null || value.toString().trim().length() == 0;
    }

    private static List<Double> toDoubleArray(List<Object> values) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object value : values) {
            if (value == null) continue;
            if (value instanceof Number) {
                Number number = (Number)value;
                list.add(number.doubleValue());
                continue;
            }
            String stringValue = value.toString();
            if (StringUtils.isBlank((String)stringValue)) continue;
            list.add(new Double(stringValue));
        }
        return list;
    }

    private static void assertNotEmpty(List<Double> values, String functionName) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Argument of function '" + functionName + "' is an empty array.");
        }
    }

    private StandardFunctions() {
    }
}

