/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.generators;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.Digest;

public class DigestRandom
extends Random {
    private static final SecureRandom seeder = new SecureRandom();
    private final byte[] in;
    private long counter;
    private final Digest digest;
    private final byte[] out;
    private int outOff;

    public DigestRandom(Digest digest) {
        this.digest = digest;
        int size = digest.getDigestSize();
        this.in = new byte[size];
        this.out = new byte[size];
        this.outOff = size;
        seeder.nextBytes(this.in);
        long time = System.currentTimeMillis();
        int i = Math.min(size, 8);
        while (--i >= 0) {
            int n = i;
            this.in[n] = (byte)((long)this.in[n] ^ time);
            time >>= 8;
        }
    }

    public synchronized void nextBytes(byte[] bytes) {
        int i = bytes.length;
        while (--i >= 0) {
            this.update();
            bytes[i] = this.out[this.outOff++];
        }
    }

    protected final int next(int numBits) {
        int numBytes = numBits + 7 >>> 3;
        int next = 0;
        int i = numBytes;
        while (--i >= 0) {
            this.update();
            next = next << 8 | this.out[this.outOff++] & 0xFF;
        }
        return next >>> (numBytes << 3) - numBits;
    }

    private void update() {
        if (this.outOff >= this.out.length) {
            long counter = ++this.counter;
            int i = this.in.length;
            while (--i >= 0) {
                this.in[i] = (byte)(counter += (long)(this.in[i] & 0xFF));
                counter >>>= 8;
            }
            this.digest.update(this.in, 0, this.in.length);
            this.digest.doFinal(this.out, 0);
            this.outOff = 0;
        }
    }
}

