/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.grid;

import ch.systemsx.cisd.cifex.client.application.grid.AbstractFilterField;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ColumnModelEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.SplitButton;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.menu.CheckMenuItem;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import java.util.List;

class FilterMenu
extends SplitButton {
    public <M extends ModelData> FilterMenu(List<AbstractFilterField<M>> filterFields, String label, ColumnModel columnModel) {
        super(label);
        Menu filterMenu = new Menu();
        for (AbstractFilterField<M> filter : filterFields) {
            CheckMenuItem menuItem = FilterMenu.createMenuItem(filter);
            FilterMenu.updateFilterAndMenu(filter, menuItem, !columnModel.isHidden(columnModel.getIndexById(filter.getProperty())));
            FilterMenu.bindColumnsAndFilters(columnModel, filter, menuItem);
            filterMenu.add((Component)menuItem);
        }
        this.setMenu(filterMenu);
    }

    private static <M extends ModelData> void updateFilterAndMenu(AbstractFilterField<M> filter, CheckMenuItem menuItem, boolean columnVisible) {
        if (!columnVisible) {
            menuItem.setChecked(columnVisible);
            FilterMenu.showFilter(filter, columnVisible);
        }
    }

    private static <M extends ModelData> void bindColumnsAndFilters(final ColumnModel columnModel, final AbstractFilterField<M> filter, final CheckMenuItem menuItem) {
        columnModel.addListener(Events.HiddenChange, (Listener)new Listener<ColumnModelEvent>(){

            public void handleEvent(ColumnModelEvent be) {
                ColumnConfig column = be.getColumnModel().getColumn(be.getColIndex());
                if (filter.getProperty().equals(column.getId())) {
                    FilterMenu.updateFilterAndMenu(filter, menuItem, !column.isHidden());
                }
            }
        });
        menuItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                if (menuItem.isChecked()) {
                    int index = columnModel.getIndexById(filter.getProperty());
                    columnModel.setHidden(index, false);
                }
            }
        });
    }

    private static <M extends ModelData> CheckMenuItem createMenuItem(final AbstractFilterField<M> filter) {
        final CheckMenuItem menuItem = new CheckMenuItem(filter.getEmptyText());
        menuItem.setChecked(filter.isEnabled(), false);
        menuItem.setHideOnClick(false);
        menuItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                FilterMenu.showFilter(filter, menuItem.isChecked());
            }
        });
        return menuItem;
    }

    private static <M extends ModelData> void showFilter(AbstractFilterField<M> filter, boolean show) {
        if (!show) {
            filter.clear();
        }
        filter.setEnabled(show);
        filter.setVisible(show);
    }
}

