/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.sql.Timestamp;
import java.util.Date;

public final class DBUtils {
    public static final Date tryToTranslateTimestampToDate(Timestamp timestampOrNull) {
        return timestampOrNull == null ? null : new Date(timestampOrNull.getTime());
    }

    public static String tryToTranslateRegExpToLikePattern(String regexpOrNull) {
        if (StringUtils.isBlank(regexpOrNull)) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int startPosition = 0;
        if (regexpOrNull.startsWith("^")) {
            ++startPosition;
        } else {
            result.append('%');
        }
        block12: while (startPosition < regexpOrNull.length()) {
            char ch = regexpOrNull.charAt(startPosition);
            if (Character.isLetter(ch) || Character.isDigit(ch) || Character.isWhitespace(ch)) {
                result.append(ch);
                ++startPosition;
                continue;
            }
            block0 : switch (ch) {
                case '\"': 
                case '#': 
                case '&': 
                case '\'': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '`': 
                case '~': {
                    result.append(ch);
                    ++startPosition;
                    break;
                }
                case '%': 
                case '_': {
                    result.append('\\').append(ch);
                    ++startPosition;
                    break;
                }
                case '.': {
                    if (++startPosition < regexpOrNull.length() && regexpOrNull.charAt(startPosition) == '*') {
                        result.append('%');
                        ++startPosition;
                        break;
                    }
                    if (startPosition < regexpOrNull.length() && regexpOrNull.charAt(startPosition) == '+') {
                        result.append('_').append('%');
                        ++startPosition;
                        break;
                    }
                    result.append('_');
                    break;
                }
                case '$': {
                    if (++startPosition >= regexpOrNull.length()) continue block12;
                    result.append(ch);
                    break;
                }
                case '\\': {
                    if (++startPosition < regexpOrNull.length()) {
                        char escaped = regexpOrNull.charAt(startPosition);
                        switch (escaped) {
                            case '\\': {
                                ++startPosition;
                                result.append('\\').append('\\');
                                break block0;
                            }
                            case '\"': 
                            case '#': 
                            case '$': 
                            case '&': 
                            case '\'': 
                            case '(': 
                            case ')': 
                            case '*': 
                            case '+': 
                            case '-': 
                            case '.': 
                            case ':': 
                            case ';': 
                            case '=': 
                            case '?': 
                            case '@': 
                            case '[': 
                            case ']': 
                            case '^': 
                            case '`': 
                            case '{': 
                            case '|': 
                            case '}': 
                            case '~': {
                                ++startPosition;
                                result.append(escaped);
                                break block0;
                            }
                            case '%': 
                            case '_': {
                                ++startPosition;
                                result.append('\\').append(escaped);
                                break block0;
                            }
                        }
                        return null;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        if (!regexpOrNull.endsWith("$")) {
            result.append('%');
        }
        return result.toString();
    }

    private DBUtils() {
    }
}

