/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.impl.DefaultDataConnectionConfiguration;
import org.apache.ftpserver.impl.PassivePorts;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnectionConfigurationFactory {
    private Logger log = LoggerFactory.getLogger(DataConnectionConfigurationFactory.class);
    private int idleTime = 300;
    private SslConfiguration ssl;
    private boolean activeEnabled = true;
    private String activeLocalAddress;
    private int activeLocalPort = 0;
    private boolean activeIpCheck = false;
    private String passiveAddress;
    private String passiveExternalAddress;
    private PassivePorts passivePorts = new PassivePorts(Collections.<Integer>emptySet(), true);
    private boolean implicitSsl;

    public DataConnectionConfiguration createDataConnectionConfiguration() {
        this.checkValidAddresses();
        return new DefaultDataConnectionConfiguration(this.idleTime, this.ssl, this.activeEnabled, this.activeIpCheck, this.activeLocalAddress, this.activeLocalPort, this.passiveAddress, this.passivePorts, this.passiveExternalAddress, this.implicitSsl);
    }

    private void checkValidAddresses() {
        try {
            InetAddress.getByName(this.passiveAddress);
            InetAddress.getByName(this.passiveExternalAddress);
        }
        catch (UnknownHostException ex) {
            throw new FtpServerConfigurationException("Unknown host", ex);
        }
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(int idleTime) {
        this.idleTime = idleTime;
    }

    public boolean isActiveEnabled() {
        return this.activeEnabled;
    }

    public void setActiveEnabled(boolean activeEnabled) {
        this.activeEnabled = activeEnabled;
    }

    public boolean isActiveIpCheck() {
        return this.activeIpCheck;
    }

    public void setActiveIpCheck(boolean activeIpCheck) {
        this.activeIpCheck = activeIpCheck;
    }

    public String getActiveLocalAddress() {
        return this.activeLocalAddress;
    }

    public void setActiveLocalAddress(String activeLocalAddress) {
        this.activeLocalAddress = activeLocalAddress;
    }

    public int getActiveLocalPort() {
        return this.activeLocalPort;
    }

    public void setActiveLocalPort(int activeLocalPort) {
        this.activeLocalPort = activeLocalPort;
    }

    public String getPassiveAddress() {
        return this.passiveAddress;
    }

    public void setPassiveAddress(String passiveAddress) {
        this.passiveAddress = passiveAddress;
    }

    public String getPassiveExternalAddress() {
        return this.passiveExternalAddress;
    }

    public void setPassiveExternalAddress(String passiveExternalAddress) {
        this.passiveExternalAddress = passiveExternalAddress;
    }

    public synchronized int requestPassivePort() {
        int dataPort = -1;
        int loopTimes = 2;
        Thread currThread = Thread.currentThread();
        while (dataPort == -1 && --loopTimes >= 0 && !currThread.isInterrupted()) {
            dataPort = this.passivePorts.reserveNextPort();
            if (dataPort != -1) continue;
            try {
                this.log.info("Out of passive ports, waiting for one to be released. Might be stuck");
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        return dataPort;
    }

    public String getPassivePorts() {
        return this.passivePorts.toString();
    }

    public void setPassivePorts(String passivePorts) {
        this.passivePorts = new PassivePorts(passivePorts, true);
    }

    public synchronized void releasePassivePort(int port) {
        this.passivePorts.releasePort(port);
        this.notify();
    }

    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    public void setSslConfiguration(SslConfiguration ssl) {
        this.ssl = ssl;
    }

    public boolean isImplicitSsl() {
        return this.implicitSsl;
    }

    public void setImplicitSsl(boolean implicitSsl) {
        this.implicitSsl = implicitSsl;
    }
}

