/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.command.CommandFactory;
import org.apache.ftpserver.command.CommandFactoryFactory;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpStatistics;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.ftpletcontainer.FtpletContainer;
import org.apache.ftpserver.ftpletcontainer.impl.DefaultFtpletContainer;
import org.apache.ftpserver.impl.DefaultFtpStatistics;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.message.MessageResource;
import org.apache.ftpserver.message.MessageResourceFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.mina.filter.executor.OrderedThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFtpServerContext
implements FtpServerContext {
    private final Logger LOG = LoggerFactory.getLogger(DefaultFtpServerContext.class);
    private MessageResource messageResource = new MessageResourceFactory().createMessageResource();
    private UserManager userManager = new PropertiesUserManagerFactory().createUserManager();
    private FileSystemFactory fileSystemManager = new NativeFileSystemFactory();
    private FtpletContainer ftpletContainer = new DefaultFtpletContainer();
    private FtpStatistics statistics = new DefaultFtpStatistics();
    private CommandFactory commandFactory = new CommandFactoryFactory().createCommandFactory();
    private ConnectionConfig connectionConfig = new ConnectionConfigFactory().createConnectionConfig();
    private Map<String, Listener> listeners = new HashMap<String, Listener>();
    private static final List<Authority> ADMIN_AUTHORITIES = new ArrayList<Authority>();
    private static final List<Authority> ANON_AUTHORITIES = new ArrayList<Authority>();
    private ThreadPoolExecutor threadPoolExecutor = null;

    public DefaultFtpServerContext() {
        this.listeners.put("default", new ListenerFactory().createListener());
    }

    public void createDefaultUsers() throws Exception {
        String adminName;
        UserManager userManager = this.getUserManager();
        if (!userManager.doesExist(adminName = userManager.getAdminName())) {
            this.LOG.info("Creating user : " + adminName);
            BaseUser adminUser = new BaseUser();
            adminUser.setName(adminName);
            adminUser.setPassword(adminName);
            adminUser.setEnabled(true);
            adminUser.setAuthorities(ADMIN_AUTHORITIES);
            adminUser.setHomeDirectory("./res/home");
            adminUser.setMaxIdleTime(0);
            userManager.save(adminUser);
        }
        if (!userManager.doesExist("anonymous")) {
            this.LOG.info("Creating user : anonymous");
            BaseUser anonUser = new BaseUser();
            anonUser.setName("anonymous");
            anonUser.setPassword("");
            anonUser.setAuthorities(ANON_AUTHORITIES);
            anonUser.setEnabled(true);
            anonUser.setHomeDirectory("./res/home");
            anonUser.setMaxIdleTime(300);
            userManager.save(anonUser);
        }
    }

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public FileSystemFactory getFileSystemManager() {
        return this.fileSystemManager;
    }

    @Override
    public MessageResource getMessageResource() {
        return this.messageResource;
    }

    @Override
    public FtpStatistics getFtpStatistics() {
        return this.statistics;
    }

    public void setFtpStatistics(FtpStatistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public FtpletContainer getFtpletContainer() {
        return this.ftpletContainer;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public Ftplet getFtplet(String name) {
        return this.ftpletContainer.getFtplet(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.listeners.clear();
        this.ftpletContainer.getFtplets().clear();
        if (this.threadPoolExecutor != null) {
            this.LOG.debug("Shutting down the thread pool executor");
            this.threadPoolExecutor.shutdown();
            try {
                this.threadPoolExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Listener getListener(String name) {
        return this.listeners.get(name);
    }

    public void setListener(String name, Listener listener) {
        this.listeners.put(name, listener);
    }

    @Override
    public Map<String, Listener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, Listener> listeners) {
        this.listeners = listeners;
    }

    public void addListener(String name, Listener listener) {
        this.listeners.put(name, listener);
    }

    public Listener removeListener(String name) {
        return this.listeners.remove(name);
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public void setFileSystemManager(FileSystemFactory fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public void setFtpletContainer(FtpletContainer ftpletContainer) {
        this.ftpletContainer = ftpletContainer;
    }

    public void setMessageResource(MessageResource messageResource) {
        this.messageResource = messageResource;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    @Override
    public synchronized ThreadPoolExecutor getThreadPoolExecutor() {
        if (this.threadPoolExecutor == null) {
            int maxThreads = this.connectionConfig.getMaxThreads();
            if (maxThreads < 1) {
                int maxLogins = this.connectionConfig.getMaxLogins();
                maxThreads = maxLogins > 0 ? maxLogins : 16;
            }
            this.LOG.debug("Intializing shared thread pool executor with max threads of {}", (Object)maxThreads);
            this.threadPoolExecutor = new OrderedThreadPoolExecutor(maxThreads);
        }
        return this.threadPoolExecutor;
    }

    static {
        ADMIN_AUTHORITIES.add(new WritePermission());
        ANON_AUTHORITIES.add(new ConcurrentLoginPermission(20, 2));
        ANON_AUTHORITIES.add(new TransferRatePermission(4800, 4800));
    }
}

