/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.file.ILineStore;
import ch.systemsx.cisd.authentication.file.IUserStore;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import java.util.ArrayList;
import java.util.List;

final class LineBasedUserStore
implements IUserStore {
    private final ILineStore lineStore;

    LineBasedUserStore(ILineStore lineStore) {
        this.lineStore = lineStore;
    }

    private UserEntry tryFindUserEntry(String user, List<String> passwordLines) {
        assert (user != null);
        assert (passwordLines != null);
        for (String line : passwordLines) {
            UserEntry entry = new UserEntry(line);
            if (!user.equals(entry.getUserId())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.lineStore.getId();
    }

    @Override
    public UserEntry tryGetUser(String user) {
        return this.tryFindUserEntry(user, this.lineStore.readLines());
    }

    @Override
    public void addOrUpdateUser(UserEntry user) {
        assert (user != null);
        List<String> passwordLines = this.lineStore.readLines();
        boolean found = false;
        int i = 0;
        while (i < passwordLines.size()) {
            String line = passwordLines.get(i);
            UserEntry entry = new UserEntry(line);
            if (entry.getUserId().equals(user.getUserId())) {
                passwordLines.set(i, user.asPasswordLine());
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            passwordLines.add(user.asPasswordLine());
        }
        this.lineStore.writeLines(passwordLines);
    }

    @Override
    public boolean removeUser(String userId) {
        assert (userId != null);
        List<String> passwordLines = this.lineStore.readLines();
        boolean found = false;
        int i = 0;
        while (i < passwordLines.size()) {
            String line = passwordLines.get(i);
            UserEntry entry = new UserEntry(line);
            if (userId.equals(entry.getUserId())) {
                passwordLines.remove(i);
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            this.lineStore.writeLines(passwordLines);
        }
        return found;
    }

    @Override
    public boolean isPasswordCorrect(String user, String password) {
        assert (user != null);
        assert (password != null);
        UserEntry userEntryOrNull = this.tryFindUserEntry(user, this.lineStore.readLines());
        if (userEntryOrNull == null) {
            return false;
        }
        return userEntryOrNull.isPasswordCorrect(password);
    }

    @Override
    public List<UserEntry> listUsers() {
        ArrayList<UserEntry> list = new ArrayList<UserEntry>();
        for (String line : this.lineStore.readLines()) {
            UserEntry user = new UserEntry(line);
            list.add(user);
        }
        return list;
    }

    @Override
    public void check() throws ConfigurationFailureException {
        this.lineStore.check();
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

