/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.application.FooterPanel;
import ch.systemsx.cisd.cifex.client.application.HtmlPage;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.LoginPanelAutofill;
import ch.systemsx.cisd.cifex.client.application.utils.ImageUtils;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;

final class LoginPage
extends VerticalPanel {
    private static final int CELL_SPACING = 20;
    private final ViewContext viewContext;

    LoginPage(ViewContext viewContext) {
        this.viewContext = viewContext;
        this.setSpacing(20);
        this.setWidth("100%");
        this.setHeight("97%");
        this.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        DockPanel loginPanel = new DockPanel();
        LoginPanelAutofill loginPanelAutofill = this.createLoginPanelAutofill();
        loginPanel.add((Widget)loginPanelAutofill, DockPanel.CENTER);
        Image cisdLogo = this.createImage();
        Anchor logo = new Anchor(cisdLogo.getElement().getString(), true, "http://www.cisd.ethz.ch/", "_blank");
        FooterPanel footerPanel = new FooterPanel(viewContext);
        HTML welcomePanel = this.createWelcomePanel();
        CellPanel northPanel = LoginPage.createNorthPanel();
        northPanel.add((Widget)logo);
        northPanel.add((Widget)welcomePanel);
        this.add((Widget)this.getBannersPage());
        this.add((Widget)northPanel);
        this.add((Widget)loginPanel);
        this.add((Widget)footerPanel);
        this.setCellVerticalAlignment((Widget)footerPanel, HasVerticalAlignment.ALIGN_BOTTOM);
    }

    private final LoginPanelAutofill createLoginPanelAutofill() {
        LoginPanelAutofill loginPanel = LoginPanelAutofill.get(this.viewContext);
        Map<String, String> urlParams = this.viewContext.getModel().getUrlParams();
        String userCode = urlParams.get("user");
        if (!StringUtils.isBlank(userCode)) {
            loginPanel.getUsernameElement().setValue(userCode);
        }
        return loginPanel;
    }

    private static final CellPanel createNorthPanel() {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(20);
        return horizontalPanel;
    }

    private final Image createImage() {
        Image image = ImageUtils.getCIFEXLogoImage();
        image.setTitle("CISD - Center for Information Sciences and Databases");
        image.setPixelSize(175, 107);
        return image;
    }

    private final HTML createWelcomePanel() {
        HTML html = new HTML("CISD File EXchanger");
        html.setStyleName("cifex-welcome");
        return html;
    }

    private HTML getBannersPage() {
        HtmlPage html = new HtmlPage("loginHeader");
        html.setStyleName("cifex-login-header");
        return html;
    }
}

