/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.application.IHistoryController;
import ch.systemsx.cisd.cifex.client.application.IPageController;
import ch.systemsx.cisd.cifex.client.application.LoginPage;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.page.HelpDialogController;
import ch.systemsx.cisd.cifex.client.application.page.MainPage;
import ch.systemsx.cisd.cifex.client.application.page.MainPageTabPanel;
import ch.systemsx.cisd.cifex.client.application.page.SettingsDialogController;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

final class PageController
implements IPageController,
IHistoryController {
    private ViewContext viewContext;
    private IHistoryController.Page currentPage;
    private IHistoryController.Page previousPage;
    private MainPageTabPanel tabPanel;
    private Widget mainPage;
    private boolean isMainPageShowing;
    private LoginPage loginPage;

    PageController() {
    }

    final void setViewContext(ViewContext viewContext) {
        this.viewContext = viewContext;
    }

    private final void clearRootPanel() {
        RootPanel rootPanel = RootPanel.get();
        rootPanel.clear();
        this.isMainPageShowing = false;
    }

    private final void showMainPage() {
        if (this.isMainPageShowing) {
            return;
        }
        this.clearRootPanel();
        this.tabPanel = new MainPageTabPanel(this.viewContext);
        this.mainPage = new MainPage(this.viewContext, this.tabPanel);
        this.isMainPageShowing = true;
        RootPanel.get().add(this.mainPage);
    }

    @Override
    public final void showLoginPage() {
        this.clearRootPanel();
        if (this.loginPage == null) {
            this.loginPage = new LoginPage(this.viewContext);
        }
        this.setCurrentPage(IHistoryController.Page.LOGIN_PAGE);
        RootPanel.get().add((Widget)this.loginPage);
    }

    @Override
    public final void showAdminPage() {
        this.showMainPage();
        this.tabPanel.showTab(MainPageTabPanel.Tab.ADMIN_TAB);
        this.setCurrentPage(IHistoryController.Page.ADMIN_PAGE);
    }

    @Override
    public final void showInboxPage() {
        this.showMainPage();
        this.tabPanel.showTab(MainPageTabPanel.Tab.INBOX_TAB);
        this.setCurrentPage(IHistoryController.Page.INBOX_PAGE);
    }

    @Override
    public final void showSharePage() {
        this.showMainPage();
        this.tabPanel.showTab(MainPageTabPanel.Tab.SHARE_TAB);
        this.setCurrentPage(IHistoryController.Page.SHARE_PAGE);
    }

    @Override
    public final void showInvitePage() {
        this.showMainPage();
        this.tabPanel.showTab(MainPageTabPanel.Tab.INVITE_TAB);
        this.setCurrentPage(IHistoryController.Page.INVITE_PAGE);
    }

    @Override
    public final void showHelpPage() {
        HelpDialogController helpDialog = new HelpDialogController(this.viewContext);
        helpDialog.getDialog().show();
    }

    @Override
    public final void showEditCurrentUserPage() {
        SettingsDialogController settingsDialog = new SettingsDialogController(this.viewContext);
        settingsDialog.getDialog().show();
    }

    @Override
    public final void refreshMainPage() {
        this.clearRootPanel();
        this.showPage(this.currentPage);
    }

    @Override
    public final void showPage(IHistoryController.Page page) {
        if (page == IHistoryController.Page.ADMIN_PAGE) {
            this.showAdminPage();
        } else if (page == IHistoryController.Page.LOGIN_PAGE) {
            this.showLoginPage();
        } else if (page == IHistoryController.Page.INBOX_PAGE) {
            this.showInboxPage();
        } else if (page == IHistoryController.Page.SHARE_PAGE) {
            this.showSharePage();
        } else if (page == IHistoryController.Page.INVITE_PAGE) {
            this.showInvitePage();
        } else {
            this.showSharePage();
        }
    }

    @Override
    public final IHistoryController.Page getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public final IHistoryController.Page getPreviousPage() {
        return this.previousPage;
    }

    @Override
    public final void setCurrentPage(IHistoryController.Page page) {
        if (this.previousPage == null) {
            this.previousPage = this.currentPage;
            this.currentPage = page;
        } else if (this.currentPage != page) {
            this.previousPage = this.currentPage;
            this.currentPage = page;
        }
    }
}

