/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.ICIFEXServiceAsync;
import ch.systemsx.cisd.cifex.client.application.AsyncCallbackAdapter;
import ch.systemsx.cisd.cifex.client.application.IHistoryController;
import ch.systemsx.cisd.cifex.client.application.IPageController;
import ch.systemsx.cisd.cifex.client.application.Model;
import com.google.gwt.user.client.Timer;

public class ViewContext {
    private final IPageController pageController;
    private final IHistoryController historyController;
    private final ICIFEXServiceAsync cifexService;
    private final Model model;
    private Timer keepAliveTimerOrNull;

    ViewContext(IPageController pageController, IHistoryController historyController, ICIFEXServiceAsync cifexService, Model model) {
        this.pageController = pageController;
        this.historyController = historyController;
        this.cifexService = cifexService;
        this.model = model;
    }

    public final ICIFEXServiceAsync getCifexService() {
        return this.cifexService;
    }

    public final Model getModel() {
        return this.model;
    }

    public final IPageController getPageController() {
        return this.pageController;
    }

    public final IHistoryController getHistoryController() {
        return this.historyController;
    }

    public void setKeepAliveTimerOrNull(Timer keepAliveTimerOrNull) {
        this.keepAliveTimerOrNull = keepAliveTimerOrNull;
    }

    public void logoutAndShowLoginPage() {
        this.getCifexService().logout(AsyncCallbackAdapter.EMPTY_ASYNC_CALLBACK);
        this.getModel().getUrlParams().clear();
        this.cancelKeepAliveTimer();
        this.getPageController().showLoginPage();
    }

    private void cancelKeepAliveTimer() {
        if (this.keepAliveTimerOrNull != null) {
            this.keepAliveTimerOrNull.cancel();
        }
    }
}

