/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.grid;

import ch.systemsx.cisd.cifex.client.application.grid.AbstractFilterField;
import ch.systemsx.cisd.cifex.client.application.grid.ColumnMenu;
import ch.systemsx.cisd.cifex.client.application.grid.ExtendedGridView;
import ch.systemsx.cisd.cifex.client.application.grid.FilterMenu;
import ch.systemsx.cisd.cifex.client.application.model.IModelDataWithID;
import ch.systemsx.cisd.cifex.client.application.utils.IDelegatedAction;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.Loader;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.PagingModelMemoryProxy;
import com.extjs.gxt.ui.client.data.SortInfo;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GridWidget<M extends IModelDataWithID> {
    private static final int PAGE_SIZE = 10;
    private final Grid<M> grid;
    private final PagingToolBar toolBar;
    private final List<AbstractFilterField<M>> filterFields;
    private List<M> models;
    private ContentPanel widget = null;

    public static <M extends IModelDataWithID> GridWidget<M> create(List<ColumnConfig> columnConfigs, List<M> models, List<AbstractFilterField<M>> filterFields) {
        return new GridWidget<M>(columnConfigs, models, filterFields);
    }

    private GridWidget(List<ColumnConfig> columnConfigs, List<M> models, List<AbstractFilterField<M>> filterFields) {
        this.models = models;
        this.filterFields = filterFields;
        this.grid = GridWidget.createGrid(columnConfigs);
        this.toolBar = this.createFilterAndPagingToolbar();
        this.refreshStore();
    }

    private PagingToolBar createFilterAndPagingToolbar() {
        IDelegatedAction onFilterAction = new IDelegatedAction(){

            @Override
            public void execute() {
                GridWidget.this.refreshStore();
            }
        };
        return GridWidget.createFilterAndPagingToolbar(this.filterFields, onFilterAction, new FilterMenu(this.filterFields, MessageDictionary.msg(MessageDictionary.GRID_FILTERS_LABEL), this.grid.getColumnModel()), new ColumnMenu(MessageDictionary.msg(MessageDictionary.GRID_COLUMNS_LABEL), this.grid.getColumnModel()));
    }

    public void setDataAndRefresh(List<M> models) {
        this.models = models;
        this.refreshStore();
    }

    public boolean removeItem(long id) {
        boolean removed = false;
        Iterator<M> it = this.models.iterator();
        while (it.hasNext()) {
            IModelDataWithID item = (IModelDataWithID)it.next();
            if (item.getID() != id) continue;
            it.remove();
            removed = true;
            break;
        }
        if (removed) {
            this.refreshStore();
        }
        return removed;
    }

    public M tryGetModel(long id) {
        for (IModelDataWithID item : this.models) {
            if (item.getID() != id) continue;
            return (M)item;
        }
        return null;
    }

    private void refreshStore() {
        SortInfo sortState = this.grid.getStore().getSortState();
        List<M> filteredModel = GridWidget.applyFilters(this.models, this.filterFields);
        PagingLoader<PagingLoadResult<M>> loader = GridWidget.createLoader(filteredModel);
        ListStore<M> store = GridWidget.createListStore(loader);
        store.sort(sortState.getSortField(), sortState.getSortDir());
        this.grid.reconfigure(store, this.grid.getColumnModel());
        GridWidget.bindAndLoad(this.toolBar, loader);
    }

    public ContentPanel getWidget() {
        if (this.widget == null) {
            this.widget = new ContentPanel();
            this.widget.setBodyBorder(false);
            this.widget.setBorders(true);
            this.widget.setHeaderVisible(false);
            this.widget.setLayout((Layout)new FitLayout());
            this.widget.add(this.grid);
            this.widget.setBottomComponent((Component)this.toolBar);
        }
        return this.widget;
    }

    public Grid<M> getGrid() {
        return this.grid;
    }

    private static <M extends ModelData> ListStore<M> createListStore(PagingLoader<PagingLoadResult<M>> loader) {
        ListStore store = new ListStore<M>((ListLoader)loader){

            public void filter(String property, String beginsWith) {
                super.filter(property);
            }
        };
        return store;
    }

    private static <M extends ModelData> PagingLoader<PagingLoadResult<M>> createLoader(List<M> data) {
        PagingModelMemoryProxy proxy = new PagingModelMemoryProxy(data);
        BasePagingLoader loader = new BasePagingLoader((DataProxy)proxy);
        loader.setRemoteSort(true);
        return loader;
    }

    private static <M extends ModelData> PagingToolBar createFilterAndPagingToolbar(List<AbstractFilterField<M>> filterFields, IDelegatedAction onFilterAction, FilterMenu filterMenu, ColumnMenu columnMenu) {
        List<Component> filterItems = GridWidget.createFilterItems(filterFields, onFilterAction, filterMenu, columnMenu);
        return new PagingToolBarWithItems(10, filterItems);
    }

    private static <M extends ModelData> void bindAndLoad(PagingToolBar toolBar, PagingLoader<PagingLoadResult<M>> loader) {
        toolBar.bind(loader);
        loader.load(0, 10);
    }

    private static <M extends ModelData> List<Component> createFilterItems(List<AbstractFilterField<M>> filterFields, IDelegatedAction onFilterAction, FilterMenu filterMenu, ColumnMenu columnMenu) {
        ArrayList<Component> filterItems = new ArrayList<Component>();
        filterItems.add((Component)columnMenu);
        filterItems.add((Component)filterMenu);
        for (AbstractFilterField<M> filterField : filterFields) {
            filterItems.add((Component)filterField);
            filterField.bind(onFilterAction);
        }
        return filterItems;
    }

    private static <M extends ModelData> Grid<M> createGrid(List<ColumnConfig> columnConfigs) {
        Grid grid = new Grid(new ListStore(), new ColumnModel(columnConfigs));
        grid.setHeight(250);
        grid.setView((GridView)new ExtendedGridView());
        return grid;
    }

    private static <M extends ModelData> List<M> applyFilters(List<M> models, List<AbstractFilterField<M>> filterFields) {
        ArrayList<ModelData> filteredModels = new ArrayList<ModelData>();
        for (ModelData model : models) {
            if (!GridWidget.isMatching(model, filterFields)) continue;
            filteredModels.add(model);
        }
        return filteredModels;
    }

    private static <M extends ModelData> boolean isMatching(M model, List<AbstractFilterField<M>> filterFields) {
        for (AbstractFilterField<M> filter : filterFields) {
            if (filter.isMatching(model)) continue;
            return false;
        }
        return true;
    }

    private static class PagingToolBarWithItems
    extends PagingToolBar {
        public PagingToolBarWithItems(int pageSize, List<Component> additionalItems) {
            super(pageSize);
            List items = this.getItems();
            int startIx = items.indexOf(this.refresh);
            items.remove(startIx);
            for (Component item : additionalItems) {
                items.add(startIx++, item);
            }
        }

        public void bind(PagingLoader<?> pagingLoader) {
            super.bind(pagingLoader);
            pagingLoader.addListener(Loader.Load, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    PagingToolBarWithItems.this.syncSize();
                }
            });
        }
    }
}

