/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.model;

import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.utils.FileUtils;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import java.util.ArrayList;
import java.util.List;

public class DownloadFileGridModel
extends AbstractFileGridModel {
    private static final long serialVersionUID = 1L;

    public DownloadFileGridModel(FileInfoDTO file) {
        this.set("id", file.getID());
        this.set("name", file.getName());
        this.set("comment", file.getComment());
        this.set("contentType", file.getContentType());
        this.set("size", FileUtils.tryToGetFileSize(file));
        this.set("owner", file.getOwner());
        this.set("crc32Checksum", file.getCrc32Str());
        this.set("registrationDate", file.getRegistrationDate());
        this.set("expirationDate", file.getExpirationDate());
    }

    @Override
    public long getID() {
        return (Long)this.get("id");
    }

    public static final List<ColumnConfig> getColumnConfigs() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(DownloadFileGridModel.createIdColumnConfig());
        configs.add(DownloadFileGridModel.createNameColumnConfig());
        configs.add(DownloadFileGridModel.createCommentColumnConfig());
        configs.add(DownloadFileGridModel.createContentTypeColumnConfig());
        configs.add(DownloadFileGridModel.createSizeColumnConfig());
        configs.add(DownloadFileGridModel.createOwnerColumnConfig());
        configs.add(DownloadFileGridModel.createCRC32ChecksumColumnConfig());
        configs.add(DownloadFileGridModel.createRegistrationDateColumnConfig());
        configs.add(DownloadFileGridModel.createExpirationDateColumnConfig());
        return configs;
    }

    public static final List<AbstractFileGridModel> convert(List<FileInfoDTO> files) {
        ArrayList<AbstractFileGridModel> result = new ArrayList<AbstractFileGridModel>();
        for (FileInfoDTO file : files) {
            result.add(new DownloadFileGridModel(file));
        }
        return result;
    }
}

