/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.FileCommentGridCellListener;
import ch.systemsx.cisd.cifex.client.application.FileDownloadGridCellListener;
import ch.systemsx.cisd.cifex.client.application.IHistoryController;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridUtils;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.model.AdminFileGridModel;
import ch.systemsx.cisd.cifex.client.application.model.UserGridModel;
import ch.systemsx.cisd.cifex.client.application.page.AbstractMainPageTabController;
import ch.systemsx.cisd.cifex.client.application.page.AdminFileActionGridCellListener;
import ch.systemsx.cisd.cifex.client.application.page.UserActionGridCellListener;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.OwnerFileInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class AdminTabController
extends AbstractMainPageTabController {
    public AdminTabController(ViewContext context, List<GridWidget<AbstractFileGridModel>> fileGridWidgets) {
        super(context, fileGridWidgets);
    }

    @Override
    protected Widget getWidget() {
        ContentPanel mainPanel = this.createOutermostWidgetContainer();
        ContentPanel createUserPanel = AdminTabController.createUserPanel(true, this.context);
        AdminTabController.addWidgetRow(mainPanel, (Widget)createUserPanel);
        GridWidget<AbstractFileGridModel> filesGrid = AdminTabController.createFileTable(new OwnerFileInfoDTO[0], this.context, this.fileGridWidgets);
        AdminTabController.addTitleRow(mainPanel, MessageDictionary.msg(MessageDictionary.LIST_FILES_TITLE));
        AdminTabController.addWidgetRow(mainPanel, (Widget)filesGrid.getWidget());
        AdminTabController.createListUserGrid(mainPanel, filesGrid, this.context);
        AdminTabController.loadListFileGrid(filesGrid, this.context);
        return mainPanel;
    }

    private static final void loadListFileGrid(GridWidget<AbstractFileGridModel> filesGrid, ViewContext context) {
        context.getCifexService().listFiles(new FileAdminAsyncCallback(context, filesGrid));
    }

    private static final void createListUserGrid(ContentPanel listUserPanel, GridWidget<AbstractFileGridModel> filesGrid, ViewContext context) {
        AdminTabController.addTitleRow(listUserPanel, MessageDictionary.msg(MessageDictionary.LIST_USERS_GRID_TITLE));
        GridWidget<UserGridModel> userGridWidget = GridUtils.createUserGrid(new ArrayList<UserInfoDTO>(), true, context);
        userGridWidget.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_USERS_LOADING_MSG));
        userGridWidget.getGrid().addListener(Events.CellClick, (Listener)new UserActionGridCellListener(context, filesGrid, userGridWidget));
        AdminTabController.addWidgetRow(listUserPanel, (Widget)userGridWidget.getWidget());
        context.getCifexService().listUsers(new UserAsyncCallback(context, userGridWidget));
    }

    private static final GridWidget<AbstractFileGridModel> createFileTable(OwnerFileInfoDTO[] files, ViewContext context, List<GridWidget<AbstractFileGridModel>> fileGridWidgets) {
        List<AbstractFileGridModel> modelData = AdminFileGridModel.convert(Arrays.asList(files));
        List<ColumnConfig> columnConfigs = AdminFileGridModel.getColumnConfigs();
        List filterItems = AbstractFileGridModel.createFilterItems(columnConfigs);
        GridWidget<AbstractFileGridModel> gridWidget = GridWidget.create(columnConfigs, modelData, filterItems);
        Grid<AbstractFileGridModel> grid = gridWidget.getGrid();
        grid.getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_FILES_LOADING_MSG));
        fileGridWidgets.add(gridWidget);
        grid.addListener(Events.CellClick, (Listener)new FileDownloadGridCellListener());
        grid.addListener(Events.CellClick, (Listener)new AdminFileActionGridCellListener(context, gridWidget, fileGridWidgets));
        grid.addListener(Events.CellClick, (Listener)new FileCommentGridCellListener());
        return gridWidget;
    }

    @Override
    protected IHistoryController.Page getPageIdentifier() {
        return IHistoryController.Page.ADMIN_PAGE;
    }

    private static final class FileAdminAsyncCallback
    extends AbstractAsyncCallback<List<OwnerFileInfoDTO>> {
        private final GridWidget<AbstractFileGridModel> filesGrid;

        FileAdminAsyncCallback(ViewContext context, GridWidget<AbstractFileGridModel> filesGrid) {
            super(context);
            this.filesGrid = filesGrid;
        }

        public final void onSuccess(List<OwnerFileInfoDTO> result) {
            this.filesGrid.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_FILES_EMPTY_MSG));
            this.filesGrid.setDataAndRefresh(AdminFileGridModel.convert(result));
        }

        @Override
        public void onFailure(Throwable caught) {
            this.filesGrid.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_FILES_EMPTY_MSG));
            super.onFailure(caught);
        }
    }

    private static final class UserAsyncCallback
    extends AbstractAsyncCallback<List<UserInfoDTO>> {
        private final ViewContext context;
        private final GridWidget<UserGridModel> userGrid;

        UserAsyncCallback(ViewContext context, GridWidget<UserGridModel> userGrid) {
            super(context);
            this.context = context;
            this.userGrid = userGrid;
        }

        public final void onSuccess(List<UserInfoDTO> result) {
            this.userGrid.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_USERS_EMPTY_MSG));
            this.userGrid.setDataAndRefresh(UserGridModel.convert(this.context, result));
        }

        @Override
        public void onFailure(Throwable caught) {
            this.userGrid.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_USERS_EMPTY_MSG));
            super.onFailure(caught);
        }
    }
}

