/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.EditFileDialog;
import ch.systemsx.cisd.cifex.client.application.FileShareUpdateUserDialog;
import ch.systemsx.cisd.cifex.client.application.IQuotaInformationUpdater;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Date;
import java.util.List;

abstract class FileActionGridCellListener
implements Listener<GridEvent<AbstractFileGridModel>> {
    private final ViewContext viewContext;
    private final boolean adminView;
    private final GridWidget<AbstractFileGridModel> myFileGridWidget;
    private final List<GridWidget<AbstractFileGridModel>> fileGridWidgets;
    private final IQuotaInformationUpdater quotaUpdaterOrNull;

    FileActionGridCellListener(boolean adminView, ViewContext viewContext, GridWidget<AbstractFileGridModel> myFileGridWidget, List<GridWidget<AbstractFileGridModel>> fileGridWidgets, IQuotaInformationUpdater quotaUpdaterOrNull) {
        this.adminView = adminView;
        this.viewContext = viewContext;
        this.myFileGridWidget = myFileGridWidget;
        this.fileGridWidgets = fileGridWidgets;
        this.quotaUpdaterOrNull = quotaUpdaterOrNull;
    }

    public void handleEvent(GridEvent<AbstractFileGridModel> be) {
        Grid<AbstractFileGridModel> grid = this.myFileGridWidget.getGrid();
        int rowIndex = be.getRowIndex();
        int colindex = be.getColIndex();
        ModelData record = grid.getStore().getAt(rowIndex);
        final long id = (Long)record.get("id");
        String name = (String)record.get("name");
        String dataIndex = grid.getColumnModel().getDataIndex(colindex);
        if (dataIndex.equals("action")) {
            Element element = be.getTarget();
            if (element == null) {
                return;
            }
            String targetId = DOM.getElementAttribute((Element)be.getTarget(), (String)"id");
            if ("delete".equals(targetId)) {
                MessageBox.confirm((String)MessageDictionary.msg(MessageDictionary.DELETE_FILE_MSGBOX_TITLE), (String)MessageDictionary.msg(MessageDictionary.DELETE_FILE_CONFIRM_LABEL, name), (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent messageEvent) {
                        if (messageEvent.getButtonClicked().getItemId().equals("yes")) {
                            if (FileActionGridCellListener.this.adminView) {
                                FileActionGridCellListener.this.viewContext.getCifexService().deleteFile(id, new AdminDeleteFileAsyncCallback(id));
                            } else {
                                FileActionGridCellListener.this.viewContext.getCifexService().deleteFile(id, new DeleteOwnedFileAsyncCallback(id));
                            }
                        }
                    }
                });
            }
            if ("edit".equals(targetId)) {
                this.viewContext.getCifexService().getFile(id, new EditFileAsyncCallback(this.viewContext, this.myFileGridWidget));
            }
            if ("shared".equals(targetId)) {
                this.viewContext.getCifexService().listUsersFileSharedWith(id, new ShowUsersFileSharedWithAsyncCallback(name, id, this.myFileGridWidget));
            }
        }
    }

    protected abstract AsyncCallback<Void> createUpdateFilesCallback(GridWidget<AbstractFileGridModel> var1, ViewContext var2);

    private final class AdminDeleteFileAsyncCallback
    extends AbstractAsyncCallback<Void> {
        private final long id;

        AdminDeleteFileAsyncCallback(long id) {
            super(FileActionGridCellListener.this.viewContext);
            this.id = id;
        }

        public final void onSuccess(Void result) {
            assert (FileActionGridCellListener.this.adminView);
            for (GridWidget widget : FileActionGridCellListener.this.fileGridWidgets) {
                widget.removeItem(this.id);
            }
        }
    }

    private final class DeleteOwnedFileAsyncCallback
    extends AbstractAsyncCallback<Void> {
        private final long id;

        DeleteOwnedFileAsyncCallback(long id) {
            super(FileActionGridCellListener.this.viewContext);
            this.id = id;
        }

        public final void onSuccess(Void result) {
            assert (!FileActionGridCellListener.this.adminView);
            for (GridWidget widget : FileActionGridCellListener.this.fileGridWidgets) {
                widget.removeItem(this.id);
            }
            if (FileActionGridCellListener.this.quotaUpdaterOrNull != null) {
                FileActionGridCellListener.this.quotaUpdaterOrNull.triggerUpdate();
            }
        }
    }

    private final class EditFileAsyncCallback
    extends AbstractAsyncCallback<FileInfoDTO> {
        private final GridWidget<AbstractFileGridModel> grid;

        public EditFileAsyncCallback(ViewContext context, GridWidget<AbstractFileGridModel> grid) {
            super(context);
            this.grid = grid;
        }

        public final void onSuccess(FileInfoDTO resultOrNull) {
            new EditFileDialog(this.getViewContext(), resultOrNull, this.createVoidAdapter(FileActionGridCellListener.this.createUpdateFilesCallback(this.grid, this.getViewContext()))).show();
        }

        private AsyncCallback<Date> createVoidAdapter(final AsyncCallback<Void> callback) {
            return new AbstractAsyncCallback<Date>(this.getViewContext()){

                public void onSuccess(Date result) {
                    callback.onSuccess(null);
                }
            };
        }
    }

    private final class ShowUsersFileSharedWithAsyncCallback
    extends AbstractAsyncCallback<List<UserInfoDTO>> {
        private final GridWidget<AbstractFileGridModel> grid;
        final String fileName;
        final long fileId;

        ShowUsersFileSharedWithAsyncCallback(String name, long id, GridWidget<AbstractFileGridModel> grid) {
            super(FileActionGridCellListener.this.viewContext);
            this.fileName = name;
            this.fileId = id;
            this.grid = grid;
        }

        public final void onSuccess(List<UserInfoDTO> result) {
            FileShareUpdateUserDialog dialog = new FileShareUpdateUserDialog(FileActionGridCellListener.this.viewContext, result, this.fileName, this.fileId, FileActionGridCellListener.this.createUpdateFilesCallback(this.grid, this.getViewContext()));
            dialog.show();
        }
    }
}

