/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.page.AbstractDialogController;
import ch.systemsx.cisd.cifex.client.application.ui.DefaultLayoutDialog;
import ch.systemsx.cisd.cifex.client.application.utils.DOMUtils;
import ch.systemsx.cisd.cifex.client.application.utils.InfoDictionary;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public class HelpDialogController
extends AbstractDialogController {
    public static final String USER_MANUAL_PDF = "CIFEX-User_Manual.pdf";
    public static final String TOOLS_HTML = "tools.html";
    public static final String DISCLAIMER_HTML = "disclaimer.html";
    public static final String FAQ_HTML = "faq.html";
    public static final String FOOTER_APPLICATION_DESCRIPTION = "<a href=\"" + InfoDictionary.info(InfoDictionary.HEADER_WEBPAGE_LINK) + "\" target=\"_blank\">CISD File EXchanger</a>";

    public HelpDialogController(ViewContext context) {
        super(context, MessageDictionary.msg(MessageDictionary.HELP_LINK_TOOLTIP));
    }

    @Override
    public Dialog getDialog() {
        DefaultLayoutDialog layoutDialog = new DefaultLayoutDialog(this.panelTitle, 500, 320, true, true);
        layoutDialog.addText(this.getHelpPageHTMLString());
        return layoutDialog;
    }

    private final String getHelpPageHTMLString() {
        StringBuffer sb = new StringBuffer();
        this.appendBlockAnchor(sb, USER_MANUAL_PDF, MessageDictionary.msg(MessageDictionary.HELP_MANUAL_LABEL));
        this.appendBlockAnchor(sb, FAQ_HTML, MessageDictionary.msg(MessageDictionary.HELP_FAQ_TITLE));
        this.appendBlockAnchor(sb, DISCLAIMER_HTML, MessageDictionary.msg(MessageDictionary.HELP_DISCLAIMER_TITLE));
        this.appendBlockAnchor(sb, TOOLS_HTML, MessageDictionary.msg(MessageDictionary.HELP_TOOLS_LABEL));
        this.appendBlock(sb, DOMUtils.createEmailAnchor(InfoDictionary.info(InfoDictionary.SUPPORT_EMAIL), MessageDictionary.msg(MessageDictionary.HELP_CONTACT_SUPPORT_LABEL)));
        sb.append(this.getApplicationDescriptionHTMLString());
        return sb.toString();
    }

    private final String getApplicationDescriptionHTMLString() {
        Element versionSpan = DOM.createSpan();
        DOM.setElementAttribute((Element)versionSpan, (String)"class", (String)"cifex-light-div");
        DOM.setInnerText((Element)versionSpan, (String)("(Version: " + this.context.getModel().getConfiguration().getSystemVersion() + ")"));
        Element descDiv = DOM.createDiv();
        StringBuffer sb = new StringBuffer();
        sb.append("<br/><br/>");
        sb.append(FOOTER_APPLICATION_DESCRIPTION);
        sb.append(" ");
        sb.append(DOM.toString((Element)versionSpan));
        DOM.setInnerHTML((Element)descDiv, (String)sb.toString());
        return DOM.toString((Element)descDiv);
    }

    private final void appendBlockAnchor(StringBuffer sb, String url, String text) {
        Element anchor = DOMUtils.createBasicAnchorElement();
        DOM.setElementAttribute((Element)anchor, (String)"target", (String)"_blank");
        DOM.setElementAttribute((Element)anchor, (String)"href", (String)url);
        DOM.setInnerText((Element)anchor, (String)text);
        this.appendBlock(sb, DOM.toString((Element)anchor));
    }

    private final void appendBlock(StringBuffer sb, String html) {
        sb.append("<div>");
        sb.append(html);
        sb.append("</div>");
    }
}

