/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.IHistoryController;
import ch.systemsx.cisd.cifex.client.application.IQuotaInformationUpdater;
import ch.systemsx.cisd.cifex.client.application.Model;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.page.AbstractMainPageTabController;
import ch.systemsx.cisd.cifex.client.application.page.FileListingTabHelper;
import ch.systemsx.cisd.cifex.client.application.ui.FileUploadWidget;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

class ShareTabController
extends AbstractMainPageTabController {
    private final FileUploadWidget fileUploadWidget;

    public ShareTabController(ViewContext context, List<GridWidget<AbstractFileGridModel>> fileGridWidgets) {
        super(context, fileGridWidgets);
        this.fileUploadWidget = new FileUploadWidget(context);
    }

    @Override
    protected Widget getWidget() {
        ContentPanel contentPanel = this.createOutermostWidgetContainer();
        HTML explanationWidget = new HTML(this.createExplanationText());
        QuotaInformationUpdater quotaInformationUpdater = new QuotaInformationUpdater(explanationWidget);
        quotaInformationUpdater.triggerUpdate();
        ShareTabController.addTitleRow(contentPanel, MessageDictionary.msg(MessageDictionary.SHARE_FILES_PANEL_TITLE));
        ShareTabController.addWidgetRow(contentPanel, (Widget)this.createUploadPart(explanationWidget));
        FileListingTabHelper.createListOwnedFilesGrid(this.context, contentPanel, this.fileGridWidgets, quotaInformationUpdater);
        return contentPanel;
    }

    @Override
    protected void onOutermostContainerWindowResize(int aWidth, int aHeight) {
        this.fileUploadWidget.onOutermostContainerWindowResize(aWidth, aHeight);
    }

    private String createExplanationText() {
        Model model = this.context.getModel();
        UserInfoDTO user = model.getUser();
        boolean isPermanent = user.isPermanent();
        StringBuilder notesText = new StringBuilder();
        if (isPermanent) {
            notesText.append(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_PERMANENT_USER_INFO, FileListingTabHelper.getMaxFileSize(user.getMaxFileSizePerQuotaGroupInMB()), FileListingTabHelper.getCurrentFileSizeInMB(user.getCurrentFileSize()), FileListingTabHelper.getMaxFileCount(user.getMaxFileCountPerQuotaGroup()), user.getCurrentFileCount()));
        } else {
            notesText.append(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_TEMPORARY_USER_INFO, FileListingTabHelper.getMaxFileSize(user.getMaxFileSizePerQuotaGroupInMB()), FileListingTabHelper.getCurrentFileSizeInMB(user.getCurrentFileSize()), FileListingTabHelper.getMaxFileCount(user.getMaxFileCountPerQuotaGroup()), user.getCurrentFileCount()));
        }
        return notesText.toString();
    }

    private ContentPanel createUploadPart(HTML explanationWidget) {
        ContentPanel verticalPanel = ShareTabController.createContainer();
        verticalPanel.add((Widget)explanationWidget, (LayoutData)new RowData(1.0, -1.0, new Margins(2, 5, 2, 5)));
        verticalPanel.add((Widget)this.fileUploadWidget, (LayoutData)new RowData(1.0, -1.0));
        return verticalPanel;
    }

    @Override
    protected IHistoryController.Page getPageIdentifier() {
        return IHistoryController.Page.SHARE_PAGE;
    }

    private final class QuotaInfoRefreshAsyncCallBack
    extends AbstractAsyncCallback<UserInfoDTO> {
        final HTML explanationWidget;

        QuotaInfoRefreshAsyncCallBack(HTML explanationWidget) {
            super(ShareTabController.this.context);
            this.explanationWidget = explanationWidget;
        }

        public final void onSuccess(UserInfoDTO result) {
            if (result != null) {
                ShareTabController.this.context.getModel().setUser(result);
                this.explanationWidget.setHTML(ShareTabController.this.createExplanationText());
            }
        }
    }

    private final class QuotaInformationUpdater
    implements IQuotaInformationUpdater {
        final HTML explanationWidget;

        QuotaInformationUpdater(HTML explanationWidget) {
            this.explanationWidget = explanationWidget;
        }

        @Override
        public void triggerUpdate() {
            ShareTabController.this.context.getCifexService().refreshQuotaInformationOfCurrentUser(new QuotaInfoRefreshAsyncCallBack(this.explanationWidget));
        }
    }
}

