/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.application.Model;
import ch.systemsx.cisd.cifex.client.application.ServletPathConstants;
import ch.systemsx.cisd.cifex.client.application.utils.WindowUtils;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import java.util.Map;

public final class FileDownloadHelper {
    private FileDownloadHelper() {
    }

    public static final boolean startFileDownload(Model model) {
        assert (model != null) : "Given model can not be null.";
        UserInfoDTO user = model.getUser();
        assert (user != null) : "Undefined user.";
        Map<String, String> urlParams = model.getUrlParams();
        String fileId = urlParams.get("fileId");
        String userCode = urlParams.get("user");
        if (fileId == null || userCode == null || !userCode.equals(user.getUserCode())) {
            return false;
        }
        try {
            String url = FileDownloadHelper.createDownloadUrl(Long.parseLong(fileId));
            WindowUtils.openNewDependentWindow(url);
        }
        catch (NumberFormatException numberFormatException) {}
        return true;
    }

    public static final String createDownloadUrl(long fileId) {
        return String.valueOf(ServletPathConstants.FILE_DOWNLOAD_SERVLET_NAME) + "?" + "fileId" + "=" + fileId;
    }
}

