/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.FileShareUploadDialog;
import ch.systemsx.cisd.cifex.client.application.ServletPathConstants;
import ch.systemsx.cisd.cifex.client.application.UserUtils;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.FileUploadFeedbackCallback;
import ch.systemsx.cisd.cifex.client.application.ui.UserTextArea;
import ch.systemsx.cisd.cifex.client.application.utils.CifexValidator;
import ch.systemsx.cisd.cifex.client.application.utils.ImageUtils;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.client.application.utils.WindowUtils;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.layout.FlowData;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.extjs.gxt.ui.client.widget.layout.TableRowLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.http.client.URL;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class FileUploadWidget
extends LayoutContainer {
    private static boolean SUBSCRIBE_TO_WINDOW_CHANGES = false;
    private static final int FILE_FIELD_NUMBER = 3;
    private final UserTextArea recipientsTextArea;
    private final ViewContext context;
    private Button submitButton;
    private Button validateButton;
    private final FormPanel formPanel;
    private final ContentPanel uploaderPanel;
    private final List<FileUploadField> uploadFields = new ArrayList<FileUploadField>();
    private final FieldSet uploadFilesFieldSet;

    public FileUploadWidget(ViewContext context) {
        this.context = context;
        TableRowLayout layout = new TableRowLayout();
        layout.setCellVerticalAlign(Style.VerticalAlignment.TOP);
        layout.setWidth("100%");
        layout.setCellSpacing(2);
        this.setLayout((Layout)layout);
        this.setBorders(false);
        this.formPanel = new FormPanel();
        this.initializeFormPanel();
        this.recipientsTextArea = new UserTextArea();
        this.initializeRecipientsTextArea();
        this.uploadFilesFieldSet = new FieldSet();
        this.initializeUploadFilesFieldSet();
        this.createForm();
        this.uploaderPanel = new ContentPanel();
        this.initializeUploaderPanel();
        this.add((Widget)this.formPanel, (LayoutData)new TableData("66%", ""));
        this.add((Widget)this.uploaderPanel, (LayoutData)new TableData("34%", ""));
        if (SUBSCRIBE_TO_WINDOW_CHANGES) {
            this.setMonitorWindowResize(true);
        }
    }

    private void initializeRecipientsTextArea() {
        this.recipientsTextArea.setAllowBlank(false);
        this.recipientsTextArea.setFieldLabel(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_RECIPIENT_FIELD_LABEL));
        this.recipientsTextArea.setToolTip(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_RECIPIENT_FIELD_TOOLTIP));
        this.recipientsTextArea.setName("email-addresses");
        this.recipientsTextArea.setPreventScrollbars(false);
        this.recipientsTextArea.setValidator(CifexValidator.getUserFieldValidator());
        this.trySetInitialValueFromURL(this.recipientsTextArea, "recipients");
    }

    private void initializeFormPanel() {
        this.formPanel.setHeading(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_BROWSER_PANEL_TITLE));
        this.formPanel.setHeaderVisible(true);
        this.formPanel.setBodyBorder(false);
        this.formPanel.setBorders(true);
        this.formPanel.setLabelAlign(FormPanel.LabelAlign.LEFT);
        this.formPanel.setButtonAlign(Style.HorizontalAlignment.LEFT);
        this.formPanel.setAction(ServletPathConstants.FILE_UPLOAD_SERVLET_NAME);
        this.formPanel.setMethod(FormPanel.Method.POST);
        this.formPanel.setEncoding(FormPanel.Encoding.MULTIPART);
        this.formPanel.setHeight(335);
    }

    private void initializeUploaderPanel() {
        this.uploaderPanel.setHeading(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_WEBSTART_PANEL_TITLE));
        this.uploaderPanel.setHeaderVisible(true);
        this.uploaderPanel.setBodyBorder(false);
        this.uploaderPanel.setBorders(true);
        this.uploaderPanel.setHeight(335);
        String webStartTitle = MessageDictionary.msg(MessageDictionary.LAUNCH_JWS_APPLICATION_TITLE);
        final String servletName = ServletPathConstants.FILE2GB_UPLOAD_SERVLET_NAME;
        String buttonTitle = MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_LAUNCH_WEBSTART_LABEL);
        Button launchButton = new Button(buttonTitle, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                WindowUtils.openNewDependentWindow(servletName);
            }
        });
        launchButton.setIcon(AbstractImagePrototype.create((ImageResource)ImageUtils.ICONS.getUploaderIcon()));
        launchButton.setTitle(webStartTitle);
        launchButton.setHeight(30);
        launchButton.setIconAlign(Style.IconAlign.LEFT);
        this.uploaderPanel.add((Widget)launchButton, (LayoutData)new FlowData(new Margins(20)));
        this.uploaderPanel.add((Widget)new Html(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_WEBSTART_PROS_INFO)), (LayoutData)new FlowData(new Margins(0, 0, 0, 10)));
    }

    private final void createForm() {
        FormData formData = new FormData("95%");
        this.submitButton = new Button(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_SUBMIT_BUTTON_LABEL));
        this.formPanel.addButton(this.submitButton);
        this.submitButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                FileUploadWidget.this.submitForm();
            }
        });
        this.submitButton.setIcon(AbstractImagePrototype.create((ImageResource)ImageUtils.ICONS.getUploaderIcon()));
        this.validateButton = new Button(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_VALIDATE_USERS_BUTTON_LABEL));
        this.formPanel.addButton(this.validateButton);
        this.validateButton.addSelectionListener(this.getUserValidateButtonListener());
        this.formPanel.addButton(new Button(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_RESET_BUTTON_LABEL), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                FileUploadWidget.this.formPanel.reset();
            }
        }));
        LayoutContainer formContainer = new LayoutContainer();
        FormLayout layout = new FormLayout();
        layout.setLabelWidth(70);
        layout.setDefaultWidth(-1);
        formContainer.setLayout((Layout)layout);
        formContainer.add(this.createRecipientsField(), (LayoutData)formData);
        formContainer.add((Widget)this.createCommentField(), (LayoutData)formData);
        formContainer.add((Widget)this.uploadFilesFieldSet, (LayoutData)formData);
        this.formPanel.add((Widget)formContainer);
    }

    private Widget createRecipientsField() {
        if (!this.context.getModel().getUser().isPermanent()) {
            String registratorUserCode;
            UserInfoDTO registratorOrNull = this.context.getModel().getUser().getRegistrator();
            String string = registratorUserCode = registratorOrNull != null ? registratorOrNull.getUserCode() : null;
            if (registratorUserCode != null) {
                this.recipientsTextArea.setValue("id:" + registratorUserCode);
            }
        }
        return this.recipientsTextArea;
    }

    private void initializeUploadFilesFieldSet() {
        TableLayout layout = new TableLayout(1);
        layout.setCellVerticalAlign(Style.VerticalAlignment.TOP);
        layout.setWidth("100%");
        layout.setCellSpacing(2);
        this.uploadFilesFieldSet.setLayout((Layout)layout);
        this.uploadFilesFieldSet.setHeading(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_PANEL_TITLE));
        int i = 0;
        while (i < 3) {
            FileUploadField field = this.createFileField(i);
            this.uploadFields.add(field);
            this.uploadFilesFieldSet.add((Widget)field, (LayoutData)new TableData("100%", ""));
            ++i;
        }
    }

    private final SelectionListener<ButtonEvent> getUserValidateButtonListener() {
        SelectionListener<ButtonEvent> buttonListener = new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                ArrayList<UserInfoDTO> existingUsers = new ArrayList<UserInfoDTO>();
                ArrayList<UserInfoDTO> newUsers = new ArrayList<UserInfoDTO>();
                String[] userEntries = FileUploadWidget.this.recipientsTextArea.getUserEntries();
                FileShareUploadDialog dialog = new FileShareUploadDialog(FileUploadWidget.this.context, existingUsers, newUsers, "Upload New Files", FileUploadWidget.this.recipientsTextArea);
                int i = 0;
                while (i < userEntries.length) {
                    if (userEntries[i].startsWith("id:")) {
                        String userCode = userEntries[i].substring("id:".length());
                        FileUploadWidget.this.tryFindUserByUserCode(userCode, dialog, existingUsers);
                    } else {
                        FileUploadWidget.this.tryFindUserByEmail(userEntries[i], dialog, existingUsers, newUsers);
                    }
                    ++i;
                }
                dialog.show();
            }
        };
        return buttonListener;
    }

    private final void tryFindUserByEmail(final String email, final FileShareUploadDialog dialog, final List<UserInfoDTO> existingUsers, final List<UserInfoDTO> newUsers) {
        this.context.getCifexService().findUserByEmail(email, (AsyncCallback<List<UserInfoDTO>>)new AbstractAsyncCallback<List<UserInfoDTO>>(this.context){

            public void onSuccess(List<UserInfoDTO> users) {
                UserInfoDTO requestUser = FileUploadWidget.this.context.getModel().getUser();
                UserUtils.removeUnsuitableUsersForSharing(requestUser, users);
                if (users.size() > 0) {
                    int j = 0;
                    while (j < users.size()) {
                        existingUsers.add(users.get(j));
                        dialog.refresh();
                        ++j;
                    }
                } else {
                    UserInfoDTO user = new UserInfoDTO();
                    user.setEmail(email);
                    user.setExpirationDate(UserUtils.getDefaultUserExpirationDate(FileUploadWidget.this.context));
                    newUsers.add(user);
                    dialog.refresh();
                }
            }
        });
    }

    private final void tryFindUserByUserCode(String userCode, final FileShareUploadDialog dialog, final List<UserInfoDTO> existingUsers) {
        this.context.getCifexService().tryFindUserByUserCodeOrCreate(userCode, (AsyncCallback<UserInfoDTO>)new AbstractAsyncCallback<UserInfoDTO>(this.context){

            public void onSuccess(UserInfoDTO result) {
                UserInfoDTO existingUser = result;
                if (existingUser != null) {
                    existingUsers.add(existingUser);
                    dialog.refresh();
                }
            }
        });
    }

    private final TextArea createCommentField() {
        UserTextArea textAreaConfig = new UserTextArea();
        textAreaConfig.setAllowBlank(true);
        textAreaConfig.setFieldLabel(MessageDictionary.msg(MessageDictionary.CREATE_USER_COMMENT_LABEL));
        textAreaConfig.setName("upload-comment");
        textAreaConfig.setPreventScrollbars(false);
        this.trySetInitialValueFromURL(textAreaConfig, "comment");
        return textAreaConfig;
    }

    private final FileUploadField createFileField(int index) {
        final FileUploadField fileField = new FileUploadField(){

            public void setReadOnly(boolean readOnly) {
                this.readOnly = readOnly;
            }
        };
        fileField.setFieldLabel(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_FILE_FIELD_LABEL, index + 1));
        fileField.setName(FileUploadWidget.getFilenameFieldName(index));
        fileField.setWidth("100%");
        fileField.setAllowBlank(index > 0);
        fileField.setValidateOnBlur(false);
        Menu menu = new Menu();
        menu.add((Component)new MenuItem(MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_RESET_BUTTON_LABEL), (SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                fileField.reset();
            }
        }));
        fileField.setContextMenu(menu);
        return fileField;
    }

    private void trySetInitialValueFromURL(UserTextArea field, String paramKey) {
        String initialValueOrNull = this.tryGetUrlParamValue(paramKey);
        if (!StringUtils.isBlank(initialValueOrNull)) {
            field.setValue(URL.decode((String)initialValueOrNull));
            field.setReadOnly(true);
        }
    }

    private String tryGetUrlParamValue(String paramKey) {
        return this.context.getModel().getUrlParams().get(paramKey);
    }

    private static final String getFilenameFieldName(int index) {
        return "upload-file-" + index;
    }

    private final List<String> getFilePaths() {
        ArrayList<String> filePaths = new ArrayList<String>(3);
        int i = 0;
        while (i < 3) {
            String fieldValue = this.uploadFields.get(i).getFileInput().getValue();
            assert (fieldValue != null) : "Must not be null.";
            String filePath = fieldValue.trim();
            if (filePath.length() > 0) {
                filePaths.add(filePath);
            }
            ++i;
        }
        return filePaths;
    }

    private boolean noDuplicates(List<String> names) {
        HashSet<String> set = new HashSet<String>(names);
        return names.size() == set.size();
    }

    protected final void submitForm() {
        if (!this.formPanel.isValid()) {
            return;
        }
        this.submitButton.disable();
        final List<String> filenames = this.getFilePaths();
        if (filenames.size() == 0) {
            this.submitButton.enable();
            return;
        }
        if (this.noDuplicates(filenames)) {
            this.registerFilenames(filenames);
        } else {
            String title = MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_DUPLICATES_MSGBOX_TITLE);
            String msg = MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_DUPLICATES_MSG);
            MessageBox.confirm((String)title, (String)msg, (Listener)new Listener<MessageBoxEvent>(){

                public void handleEvent(MessageBoxEvent messageEvent) {
                    if (messageEvent.getButtonClicked().getItemId().equals("yes")) {
                        FileUploadWidget.this.registerFilenames(filenames);
                    } else {
                        FileUploadWidget.this.submitButton.enable();
                    }
                }
            });
        }
    }

    private void registerFilenames(List<String> filenames) {
        this.context.getCifexService().registerFilenamesForUpload(filenames.toArray(StringUtils.EMPTY_STRING_ARRAY), (AsyncCallback<Void>)new AbstractAsyncCallback<Void>(this.context){

            public final void onSuccess(Void result) {
                FileUploadWidget.this.formPanel.submit();
                FileUploadWidget.this.context.getCifexService().getFileUploadFeedback(new FileUploadFeedbackCallback(FileUploadWidget.this.context, FileUploadWidget.this.submitButton));
            }

            @Override
            public final void onFailure(Throwable caught) {
                super.onFailure(caught);
                FileUploadWidget.this.submitButton.enable();
            }
        });
    }

    protected void onWindowResize(int aWidth, int aHeight) {
        super.onWindowResize(aWidth, aHeight);
        this.formPanel.layout(true);
        this.uploadFilesFieldSet.layout(true);
    }

    public void onOutermostContainerWindowResize(int aWidth, int aHeight) {
        this.onWindowResize(aWidth, aHeight);
    }
}

