/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.application.Model;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.FileDownloadHelper;
import ch.systemsx.cisd.cifex.shared.basic.dto.CurrentUserInfoDTO;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;

public final class PageControllerHelper {
    private static final int MILLIS_PER_MIN = 60000;
    private static final int KEEPALIVE_TIMER_PERIOD_MILLIS = 60000;
    private static final int MIN_KEEPALIVE_PINGS_PER_TIMEOUT_PERIOD = 4;

    public static final void activatePageBasedOnCurrentContext(ViewContext context, CurrentUserInfoDTO currentUser) {
        if (currentUser != null) {
            Model model = context.getModel();
            model.setUser(currentUser);
            PageControllerHelper.keepSessionAlive(context);
            if (FileDownloadHelper.startFileDownload(model) || currentUser.hasFilesForDownload() && !PageControllerHelper.isUploadTriggered(model)) {
                context.getPageController().showInboxPage();
            } else {
                context.getPageController().showSharePage();
            }
        } else {
            context.getPageController().showLoginPage();
        }
    }

    private static boolean isUploadTriggered(Model model) {
        return model.getUrlParams().containsKey("recipients");
    }

    private static void keepSessionAlive(final ViewContext context) {
        Timer t = new Timer(){

            public void run() {
                AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

                    public void onSuccess(Boolean result) {
                        if (!result.booleanValue()) {
                            this.cancel();
                        }
                    }

                    public void onFailure(Throwable caught) {
                        this.cancel();
                    }
                };
                context.getCifexService().keepSessionAlive(callback);
            }
        };
        context.setKeepAliveTimerOrNull(t);
        int sessionTimeoutMillis = context.getModel().getConfiguration().getSessionTimeoutMin() * 60000;
        int keepAliveTimerPeriod = Math.min(60000, sessionTimeoutMillis / 4);
        t.scheduleRepeating(keepAliveTimerPeriod);
    }
}

