/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.cifex.rpc.ICIFEXRPCService;
import ch.systemsx.cisd.cifex.rpc.client.Downloader;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXDownloader;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXUploader;
import ch.systemsx.cisd.cifex.rpc.client.Uploader;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;

public class CIFEXComponent
implements ICIFEXComponent {
    private final ICIFEXRPCService service;

    public CIFEXComponent(ICIFEXRPCService service) {
        this.service = service;
    }

    @Override
    public ICIFEXDownloader createDownloader(String sessionID) {
        return Downloader.create(this.service, sessionID);
    }

    @Override
    public ICIFEXUploader createUploader(String sessionID) {
        return new Uploader(this.service, sessionID);
    }

    @Override
    public void deleteFile(String sessionID, long fileId) throws InvalidSessionException, UserFailureException {
        this.service.deleteFile(sessionID, fileId);
    }

    @Override
    public FileInfoDTO[] listDownloadFiles(String sessionID) throws InvalidSessionException, EnvironmentFailureException {
        return this.service.listDownloadFiles(sessionID);
    }

    @Override
    public FileInfoDTO[] listOwnedFiles(String sessionID) throws InvalidSessionException, EnvironmentFailureException {
        return this.service.listOwnedFiles(sessionID);
    }

    @Override
    public String login(String user, String password) throws AuthorizationFailureException {
        return this.service.login(user, password);
    }

    @Override
    public void logout(String sessionID) {
        this.service.logout(sessionID);
    }

    @Override
    public void setSessionUser(String sessionID, String newSessionUser) {
        this.service.setSessionUser(sessionID, newSessionUser);
    }

    @Override
    public void checkSession(String sessionID) throws InvalidSessionException {
        this.service.checkSession(sessionID);
    }
}

