/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.cifex.rpc.ICIFEXRPCService;
import ch.systemsx.cisd.cifex.rpc.client.CIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ClientConfigurationFiles;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.IncompatibleAPIVersionsException;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.common.ssl.SslCertificateHelper;
import com.marathon.util.spring.StreamSupportingHttpInvokerProxyFactoryBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;

public final class RPCServiceFactory {
    private static final String SPRING_BEAN_URL_PROTOCOL = "spring-bean://";
    private static final int SERVER_TIMEOUT_MIN = 5;

    private RPCServiceFactory() {
    }

    public static ICIFEXComponent createCIFEXComponent(String serviceURL, boolean getServerCertificateFromServer) throws IncompatibleAPIVersionsException {
        ClassLoader classLoader = RPCServiceFactory.class.getClassLoader();
        ICIFEXRPCService service = RPCServiceFactory.createService(serviceURL, getServerCertificateFromServer);
        ServiceInvocationHandler invocationHandler = new ServiceInvocationHandler(service);
        ICIFEXRPCService proxy = (ICIFEXRPCService)Proxy.newProxyInstance(classLoader, new Class[]{ICIFEXRPCService.class}, (InvocationHandler)invocationHandler);
        int apiServerVersion = proxy.getVersion();
        int apiMinClientVersion = proxy.getMinClientVersion();
        if (5 < apiMinClientVersion || 5 > apiServerVersion) {
            throw new IncompatibleAPIVersionsException(5, apiServerVersion, apiMinClientVersion);
        }
        return new CIFEXComponent(proxy);
    }

    private static ICIFEXRPCService createService(String serviceURL, boolean getServerCertificateFromServer) {
        if (serviceURL.startsWith(SPRING_BEAN_URL_PROTOCOL)) {
            ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"}, true);
            LogInitializer.init();
            return (ICIFEXRPCService)applicationContext.getBean("rpc-service");
        }
        if (getServerCertificateFromServer) {
            RPCServiceFactory.setUpKeyStore(serviceURL);
        }
        StreamSupportingHttpInvokerProxyFactoryBean httpInvokerProxy = new StreamSupportingHttpInvokerProxyFactoryBean();
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(ICIFEXRPCService.class);
        ((CommonsHttpInvokerRequestExecutor)httpInvokerProxy.getHttpInvokerRequestExecutor()).setReadTimeout(300000);
        InetSocketAddress proxyAddressOrNull = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddressOrNull != null) {
            ((CommonsHttpInvokerRequestExecutor)httpInvokerProxy.getHttpInvokerRequestExecutor()).getHttpClient().getHostConfiguration().setProxy(proxyAddressOrNull.getHostName(), proxyAddressOrNull.getPort());
        }
        httpInvokerProxy.afterPropertiesSet();
        return (ICIFEXRPCService)httpInvokerProxy.getObject();
    }

    private static void setUpKeyStore(String serviceURL) {
        new SslCertificateHelper(serviceURL, ClientConfigurationFiles.KEYSTORE_FILE, "cifex").setUpKeyStore();
    }

    private static final class ServiceInvocationHandler
    implements InvocationHandler {
        private final ICIFEXRPCService service;

        private ServiceInvocationHandler(ICIFEXRPCService service) {
            this.service = service;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.service, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
    }
}

