/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.client.ClientConfigurationFiles;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.IProgressListenerHolder;
import ch.systemsx.cisd.cifex.rpc.client.IncompatibleAPIVersionsException;
import ch.systemsx.cisd.cifex.rpc.client.RPCServiceFactory;
import ch.systemsx.cisd.cifex.rpc.client.cli.ICommand;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.security.PasswordGenerator;
import java.io.File;
import java.io.IOException;
import jline.ConsoleReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

abstract class AbstractCommand
implements ICommand {
    private static final PasswordGenerator passwordGenerator = new PasswordGenerator();
    static String configuredBaseURL;
    private final String name;
    private ConsoleReader consoleReader;

    static {
        if (ClientConfigurationFiles.BASE_URL_FILE.exists()) {
            try {
                configuredBaseURL = FileUtils.readFileToString((File)ClientConfigurationFiles.BASE_URL_FILE);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        if (configuredBaseURL == null && System.getProperty("cifex.base.url") != null) {
            configuredBaseURL = System.getProperty("cifex.base.url");
        }
    }

    static String generatePassphrase(boolean shortPassphrase) {
        if (shortPassphrase) {
            return passwordGenerator.generatePassword(10, true);
        }
        return passwordGenerator.generatePassword(40, false);
    }

    AbstractCommand(String name) {
        assert (StringUtils.isNotBlank((String)name));
        this.name = name;
    }

    protected final ConsoleReader getConsoleReader() {
        if (this.consoleReader == null) {
            try {
                this.consoleReader = new ConsoleReader();
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("ConsoleReader could not be instantiated.", ex);
            }
        }
        return this.consoleReader;
    }

    protected final String tryGetPassphrase(String label, String passphraseOrNull) {
        String passphrase = passphraseOrNull;
        if (StringUtils.isBlank((String)passphrase)) {
            try {
                passphrase = this.getConsoleReader().readLine(label, Character.valueOf('*'));
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("I/O Exception while getting passphrase.", ex);
            }
        }
        if (StringUtils.isBlank((String)passphrase)) {
            return null;
        }
        return passphrase;
    }

    protected final ICIFEXComponent tryGetComponent() {
        return this.tryGetComponent(configuredBaseURL, false);
    }

    protected final ICIFEXComponent tryGetComponent(String baseURL, boolean initializeTrustStore) {
        if (StringUtils.isBlank((String)baseURL)) {
            System.err.println("This CIFEX client has not been initialized. Run the command 'init' first.");
            return null;
        }
        String serviceURL = String.valueOf(baseURL) + "/cifex/rpc-service";
        try {
            ICIFEXComponent cifexComponent = RPCServiceFactory.createCIFEXComponent(serviceURL, initializeTrustStore);
            return cifexComponent;
        }
        catch (IncompatibleAPIVersionsException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    protected void addConsoleProgressListener(IProgressListenerHolder downloader, final boolean printFilenameOnStart, final boolean noProgressFeedback) {
        downloader.addProgressListener(new IProgressListener(){
            long size;

            @Override
            public void start(File file, String operationName, long fileSize, Long fileIdOrNull) {
                this.size = fileSize;
                if (printFilenameOnStart) {
                    System.out.println(file.getName());
                }
            }

            @Override
            public void reportProgress(int percentage, long numberOfBytes) {
                if (!noProgressFeedback) {
                    System.out.print("\r" + percentage + "% (" + numberOfBytes + "/" + this.size + ")");
                }
            }

            @Override
            public void finished(boolean successful) {
                this.size = 0L;
                if (!noProgressFeedback) {
                    System.out.println();
                }
            }

            @Override
            public void warningOccured(String warningMessage) {
                System.out.println();
                System.err.println(warningMessage);
            }

            @Override
            public void exceptionOccured(Throwable throwable) {
            }
        });
    }

    @Override
    public final String getName() {
        return this.name;
    }
}

