/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXDownloader;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.cifex.rpc.client.encryption.OpenPGPSymmetricKeyEncryption;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class FileDownloadAllCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "download_all";
    private static FileDownloadAllCommand instance;
    private Parameters parameters;

    private FileDownloadAllCommand() {
        super(NAME);
    }

    @Override
    protected Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters(this.arguments);
        }
        return this.parameters;
    }

    public static final synchronized FileDownloadAllCommand getInstance() {
        if (instance == null) {
            instance = new FileDownloadAllCommand();
        }
        return instance;
    }

    private String getPassphraseOrExit(String label) {
        String passphrase = this.tryGetPassphrase(label, this.parameters.getPassphrase());
        if (StringUtils.isBlank((String)passphrase)) {
            System.err.println("No password has been specified.");
            System.exit(1);
        }
        return passphrase;
    }

    @Override
    protected boolean isHelpRequest(String[] args) {
        this.arguments = args;
        return this.getParameters().isHelpRequest();
    }

    @Override
    protected int execute(String sessionToken, ICIFEXComponent cifex, String[] args) throws UserFailureException, EnvironmentFailureException {
        ICIFEXDownloader downloader = cifex.createDownloader(sessionToken);
        this.addConsoleProgressListener(downloader, true, this.getParameters().beQuiet());
        String passphrase = this.getParameters().isDecrypt() ? this.getPassphraseOrExit("Passphrase: ") : null;
        FileInfoDTO[] fileInfoDTOArray = cifex.listDownloadFiles(sessionToken);
        int n = fileInfoDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileInfoDTO fileInfo = fileInfoDTOArray[n2];
            File file = downloader.download(fileInfo.getID(), this.getParameters().getDirectory(), null, true);
            if (this.getParameters().isDecrypt()) {
                File clearTextFile = OpenPGPSymmetricKeyEncryption.decrypt(file, null, passphrase, this.getParameters().isOverwriteOutputFile());
                System.out.println("\nDecrypted file is '" + clearTextFile + "'.");
            }
            ++n2;
        }
        return 0;
    }

    private static class Parameters
    extends MinimalParameters {
        @Option(name="d", longName="directory", metaVar="DIR", usage="Directory to download the files to.")
        private File directory;
        @Option(name="q", longName="quiet", usage="Suppress progress reporting.")
        private boolean quiet;
        @Option(name="D", longName="decrypt", usage="Decrypt files after downloading.")
        private boolean decrypt;
        @Option(name="p", longName="passphrase", metaVar="STRING", usage="The pass phrase to use for encryption.")
        private String passphrase;
        @Option(name="O", longName="overwrote-output-file", metaVar="FLAG", usage="Whether an already existing output file for the local decrypted file should be silently overwritten (only used if decryption is enabled).")
        private boolean overwriteOutputFile;

        public Parameters(String[] args) {
            super(args, FileDownloadAllCommand.NAME, "");
            if (!this.getArgs().isEmpty()) {
                this.printHelp(true);
            }
        }

        public File getDirectory() {
            if (this.directory == null) {
                return new File(".");
            }
            if (!this.directory.isDirectory()) {
                this.directory.mkdirs();
            }
            return this.directory;
        }

        public boolean beQuiet() {
            return this.quiet;
        }

        public boolean isDecrypt() {
            return this.decrypt || this.passphrase != null;
        }

        public boolean isOverwriteOutputFile() {
            return this.overwriteOutputFile;
        }

        public String getPassphrase() {
            return this.passphrase;
        }
    }
}

