/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;

public class ListDownloadFilesCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list";
    private static ListDownloadFilesCommand instance;

    ListDownloadFilesCommand() {
        super(NAME);
    }

    public static final synchronized ListDownloadFilesCommand getInstance() {
        if (instance == null) {
            instance = new ListDownloadFilesCommand();
        }
        return instance;
    }

    @Override
    protected boolean isHelpRequest(String[] args) {
        this.arguments = args;
        return this.getParameters().isHelpRequest();
    }

    @Override
    protected int execute(String sessionToken, ICIFEXComponent cifex, String[] args) throws UserFailureException, EnvironmentFailureException {
        this.getParameters().assertArgsEmpty();
        FileInfoDTO[] files = cifex.listDownloadFiles(sessionToken);
        if (files.length == 0) {
            System.out.println("No files available for you to download.");
        } else {
            System.out.println("Id\tName\tSize\tCRC32\tContent Type\tOwner\tExpiration\tComment");
            FileInfoDTO[] fileInfoDTOArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileInfoDTO file = fileInfoDTOArray[n2];
                String crc32 = file.getCrc32Str() == null ? "-" : file.getCrc32Str();
                System.out.println(String.valueOf(file.getID()) + "\t" + file.getName() + "\t" + file.getSize() + "\t" + crc32 + "\t" + file.getContentType() + "\t" + file.getOwner() + "\t" + file.getExpirationDate() + "\t" + file.getComment());
                ++n2;
            }
        }
        return 0;
    }
}

