/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.client.ClientConfigurationFiles;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.Credentials;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class LoginCommand
extends AbstractCommand {
    private static final String NAME = "login";
    private static LoginCommand instance;

    private LoginCommand() {
        super(NAME);
    }

    public static final synchronized LoginCommand getInstance() {
        if (instance == null) {
            instance = new LoginCommand();
        }
        return instance;
    }

    @Override
    public final int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ICIFEXComponent cifexOrNull = this.tryGetComponent();
        if (cifexOrNull == null) {
            return 2;
        }
        Credentials credentials = parameters.getCredentials();
        try {
            credentials = this.getCredentials(credentials);
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("I/O Exception while getting credentials.", ex);
        }
        if (credentials == null) {
            System.err.println("Credentials are not valid.");
            return 1;
        }
        String sessionToken = cifexOrNull.login(credentials.getUserName(), credentials.getPassword());
        return LoginCommand.processSessionToken(sessionToken, credentials.getUserName());
    }

    private static final int processSessionToken(String sessionToken, String user) {
        if (sessionToken == null) {
            System.out.println("Authentication failed for user " + user);
            return 1;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(ClientConfigurationFiles.SESSION_TOKEN_FILE);
            writer.write(sessionToken);
            System.out.println("Successfully authenticated.");
        }
        catch (IOException e) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return 0;
    }

    private final Credentials getCredentials(Credentials initial) throws IOException {
        String password;
        String userName = initial.getUserName();
        if (StringUtils.isBlank((String)userName)) {
            userName = this.getConsoleReader().readLine("User: ");
        }
        if (StringUtils.isBlank((String)userName)) {
            System.err.println("No user name has been specified.");
            System.exit(1);
        }
        if (StringUtils.isBlank((String)(password = initial.getPassword()))) {
            password = this.getConsoleReader().readLine("Password: ", Character.valueOf('*'));
        }
        if (StringUtils.isBlank((String)password)) {
            System.err.println("No password has been specified.");
            System.exit(1);
        }
        return new Credentials(userName, password);
    }

    private static final class Parameters
    extends MinimalParameters {
        @Option(name="u", longName="username", usage="User login name")
        private String username;
        @Option(name="p", longName="password", usage="User login password")
        private String password;
        private final Credentials credentials;

        public Parameters(String[] args) {
            super(args, LoginCommand.NAME);
            this.credentials = new Credentials(this.username, this.password);
        }

        Credentials getCredentials() {
            return this.credentials;
        }
    }
}

