/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.RPCServiceFactory;
import ch.systemsx.cisd.cifex.shared.basic.UserFailureException;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;

class CIFEXCommunicationState {
    private final String sessionId;
    private final ICIFEXComponent cifex;

    protected CIFEXCommunicationState(String[] args) throws UserFailureException, EnvironmentFailureException {
        if (args.length < 2) {
            throw new ConfigurationFailureException("The CIFEX File Download Client was improperly configured -- the arguments it requires were not supplied. Please talk to the CIFEX administrator.");
        }
        String serviceURL = args[0];
        this.cifex = RPCServiceFactory.createCIFEXComponent(serviceURL, true);
        switch (args.length) {
            case 2: {
                this.sessionId = args[1];
                break;
            }
            default: {
                String userName = args[1];
                String passwd = args[2];
                this.sessionId = this.cifex.login(userName, passwd);
            }
        }
    }

    String getSessionId() {
        return this.sessionId;
    }

    ICIFEXComponent getCifex() {
        return this.cifex;
    }
}

