/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.FileItem;
import ch.systemsx.cisd.cifex.rpc.client.FileItemStatus;
import ch.systemsx.cisd.cifex.rpc.client.FileWithOverrideName;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXUploader;
import ch.systemsx.cisd.cifex.rpc.client.PersistenceStore;
import ch.systemsx.cisd.cifex.rpc.client.encryption.OpenPGPSymmetricKeyEncryption;
import ch.systemsx.cisd.cifex.rpc.client.gui.AbstractSwingGUI;
import ch.systemsx.cisd.cifex.rpc.client.gui.CIFEXCommunicationState;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileChooserUtils;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.cifex.rpc.client.gui.PassphraseDialog;
import ch.systemsx.cisd.cifex.rpc.client.gui.SpringLayoutUtilities;
import ch.systemsx.cisd.cifex.rpc.client.gui.UploadTableCellRenderer;
import ch.systemsx.cisd.cifex.rpc.client.gui.UploadTableModel;
import ch.systemsx.cisd.cifex.shared.basic.UserFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.security.PasswordGenerator;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.StringUtils;

public class FileUploadClient
extends AbstractSwingGUI {
    private static final int LINE_HEIGHT = 30;
    private static final int INPUT_WIDTH = 600;
    private static final String TITLE = "CIFEX Uploader";
    private static final String REMOVE_FROM_TABLE_MENU_ITEM = "Remove selected files from table";
    private final ICIFEXUploader uploader;
    private final PasswordGenerator passphraseGenerator;
    private JButton uploadButton;
    private JButton cancelButton;
    private JButton addButton;
    private JButton encryptButton;
    private JPopupMenu popupMenu;
    private UploadTableModel tableModel;
    private JTextArea recipientsTextArea;
    private JTextArea commentTextArea;
    private String passphrase = "";
    private boolean deleteEncryptedFilesAfterSuccessfulUpload = PersistenceStore.isDeleteEncryptedFiles();
    final List<File> encryptedFilesToBeDeleted = new LinkedList<File>();
    private File workingDirectory;

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    public static void main(String[] args) throws UserFailureException, EnvironmentFailureException {
        FileUploadClient.setLookAndFeelToNative();
        try {
            CIFEXCommunicationState commState = new CIFEXCommunicationState(args);
            FileUploadClient newMe = new FileUploadClient(commState, SystemTimeProvider.SYSTEM_TIME_PROVIDER);
            newMe.show();
        }
        catch (RuntimeException ex) {
            JFrame frame = new JFrame(TITLE);
            frame.setVisible(true);
            JOptionPane.showMessageDialog(frame, ex.getMessage(), "Error", 0);
            System.exit(1);
        }
    }

    FileUploadClient(CIFEXCommunicationState commState, ITimeProvider timeProvider) {
        super(commState);
        this.passphraseGenerator = new PasswordGenerator();
        this.uploader = this.cifex.createUploader(this.sessionId);
        this.workingDirectory = PersistenceStore.getWorkingDirectory();
        this.tableModel = new UploadTableModel(this.uploader, timeProvider);
        this.createGUI();
        this.addProgressListener();
    }

    private void addProgressListener() {
        this.uploader.addProgressListener(this.createErrorLogListener());
        this.uploader.addProgressListener(this.createEncryptedFileDeletionListener());
        this.uploader.addProgressListener(this.createFinishLogListenerWhoExitsProgram());
    }

    private IProgressListener createEncryptedFileDeletionListener() {
        return new IProgressListener(){

            @Override
            public void start(File file, String operationName, long fileSize, Long fileIdOrNull) {
            }

            @Override
            public void reportProgress(int percentage, long numberOfBytes) {
            }

            @Override
            public void finished(boolean successful) {
                if (successful && FileUploadClient.this.doDeleteEncryptedFilesAfterSuccessfulUpload()) {
                    for (File file : FileUploadClient.this.encryptedFilesToBeDeleted) {
                        if (file.delete()) continue;
                        JOptionPane.showMessageDialog(FileUploadClient.this.getWindowFrame(), "Failed to delete file '" + file.getAbsolutePath() + "'.", "Warning", 2);
                    }
                }
            }

            @Override
            public void exceptionOccured(Throwable throwable) {
            }

            @Override
            public void warningOccured(String warningMessage) {
            }
        };
    }

    private IProgressListener createFinishLogListenerWhoExitsProgram() {
        return new IProgressListener(){

            @Override
            public void finished(boolean successful) {
                FileUploadClient.this.setEnableStateOfButtons(true);
                if (successful) {
                    JOptionPane.showMessageDialog(FileUploadClient.this.getWindowFrame(), "Uploading finished. Please refresh CIFEX in your Web browser.");
                    System.exit(0);
                } else {
                    JOptionPane.showMessageDialog(FileUploadClient.this.getWindowFrame(), "Operation did not complete successfully. Check the status in the CIFEX Web GUI (Uploaded Files > Edit Sharing)", "Warning", 2);
                }
            }

            @Override
            public void start(File file, String operationName, long fileSize, Long fileIdOrNull) {
            }

            @Override
            public void reportProgress(int percentage, long numberOfBytes) {
            }

            @Override
            public void exceptionOccured(Throwable throwable) {
            }

            @Override
            public void warningOccured(String warningMessage) {
            }
        };
    }

    void show() {
        this.getWindowFrame().setVisible(true);
    }

    private void createGUI() {
        JFrame window = this.getWindowFrame();
        JPanel panel = this.createGUIPanel();
        window.add((Component)panel, "Center");
        JLabel spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(5, 5));
        window.add((Component)spacer, "West");
        spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(5, 5));
        window.add((Component)spacer, "East");
        spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(600, 15));
        window.add((Component)spacer, "South");
        spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(600, 15));
        window.add((Component)spacer, "North");
        window.pack();
        window.setLocationByPlatform(true);
        window.setVisible(true);
    }

    private JPanel createGUIPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 5));
        JPanel fileListPanel = this.createFileListPanel();
        JPanel actionButtonsPanel = this.createActionButtonsPanel();
        panel.add((Component)fileListPanel, "Center");
        panel.add((Component)actionButtonsPanel, "South");
        return panel;
    }

    private JPanel createFileListPanel() {
        JPanel panel = new JPanel(new SpringLayout());
        JLabel label = new JLabel("Recipients", 11);
        this.recipientsTextArea = new JTextArea();
        this.recipientsTextArea.setPreferredSize(new Dimension(600, 90));
        label.setLabelFor(this.recipientsTextArea);
        panel.add(label);
        panel.add(new JScrollPane(this.recipientsTextArea));
        label = new JLabel("Comment", 11);
        this.commentTextArea = new JTextArea();
        this.commentTextArea.setPreferredSize(new Dimension(600, 90));
        label.setLabelFor(this.commentTextArea);
        panel.add(label);
        panel.add(new JScrollPane(this.commentTextArea));
        label = new JLabel("Files", 11);
        JTable table = new JTable(this.tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent evt) {
                int index = this.rowAtPoint(evt.getPoint());
                File file = FileUploadClient.this.tableModel.getFileItem(index).getFile();
                String size = FileUtilities.byteCountToDisplaySize(file.length());
                return String.valueOf(file.getAbsolutePath()) + " (" + size + ")";
            }
        };
        table.setColumnModel(this.createTableColumnModel());
        this.popupMenu = this.createPopupMenu(table);
        JScrollPane filesPane = new JScrollPane(table);
        filesPane.setMinimumSize(new Dimension(600, 60));
        filesPane.setPreferredSize(new Dimension(600, 180));
        label.setLabelFor(filesPane);
        panel.add(label);
        panel.add(filesPane);
        SpringLayoutUtilities.makeCompactGrid(panel, 3, 2, 5, 5, 5, 5);
        JPanel fileListPanel = new JPanel();
        fileListPanel.setLayout(new BorderLayout());
        JPanel buttonsPanel = this.createFileListButtonsPanel();
        fileListPanel.add((Component)panel, "Center");
        fileListPanel.add((Component)buttonsPanel, "Last");
        return fileListPanel;
    }

    private JPanel createFileListButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(buttonsPanel, 2);
        buttonsPanel.setLayout(layout);
        final JCheckBox willEncrypt = new JCheckBox("Will Encrypt");
        willEncrypt.setEnabled(false);
        this.encryptButton = new JButton("Encrypt\u2026");
        this.encryptButton.setToolTipText("Encrypt files before uploading");
        this.encryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PassphraseDialog.PassphraseAndFileDeletion newPassphraseAndFileDeletionOrNull = PassphraseDialog.tryGetPassphraseForEncrypt(FileUploadClient.this.getWindowFrame(), FileUploadClient.this.passphrase, FileUploadClient.this.deleteEncryptedFilesAfterSuccessfulUpload, FileUploadClient.this.passphraseGenerator, "Encrypt Files", "Enter Passphrase");
                if (newPassphraseAndFileDeletionOrNull != null) {
                    FileUploadClient.this.passphrase = newPassphraseAndFileDeletionOrNull.getPassphrase();
                    FileUploadClient.this.deleteEncryptedFilesAfterSuccessfulUpload = newPassphraseAndFileDeletionOrNull.tryGetDeleteEncrypted();
                    willEncrypt.setSelected(FileUploadClient.this.doEncrypt());
                }
            }
        });
        this.addButton = new JButton("Add File\u2026");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileUploadClient.this.chooseAndAddFile();
            }
        });
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(willEncrypt);
        buttonsPanel.add(Box.createHorizontalStrut(10));
        buttonsPanel.add(this.encryptButton);
        buttonsPanel.add(Box.createHorizontalStrut(10));
        buttonsPanel.add(this.addButton);
        return buttonsPanel;
    }

    private JPanel createActionButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        this.uploadButton = this.createUploadButton(this.tableModel);
        this.cancelButton = new JButton("Stop");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileUploadClient.this.cancel();
            }
        });
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        buttonsPanel.add(this.uploadButton);
        return buttonsPanel;
    }

    private JButton createUploadButton(final UploadTableModel fileListModel) {
        final JButton button = new JButton("Upload");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileUploadClient.this.setEnableStateOfButtons(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        List files = FileUploadClient.this.wrapFiles(fileListModel.getFiles());
                        String recipients = FileUploadClient.this.recipientsTextArea.getText();
                        String comment = FileUploadClient.this.commentTextArea.getText();
                        List actualFiles = FileUploadClient.this.encryptFilesIfRequested(files);
                        if (actualFiles.isEmpty()) {
                            FileUploadClient.this.setEnableStateOfButtons(true);
                            return;
                        }
                        try {
                            FileUploadClient.this.uploader.upload(actualFiles, recipients, comment);
                        }
                        catch (Throwable throwable) {}
                    }
                }).start();
            }
        });
        button.setEnabled(false);
        fileListModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() != 0) {
                    button.setEnabled(fileListModel.getFiles().size() > 0);
                }
            }
        });
        return button;
    }

    private List<FileWithOverrideName> wrapFiles(List<File> files) {
        ArrayList<FileWithOverrideName> filesWithOverrideName = new ArrayList<FileWithOverrideName>(files.size());
        for (File file : files) {
            filesWithOverrideName.add(new FileWithOverrideName(file, null));
        }
        return filesWithOverrideName;
    }

    private JPopupMenu createPopupMenu(final JTable table) {
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(REMOVE_FROM_TABLE_MENU_ITEM);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (FileUploadClient.REMOVE_FROM_TABLE_MENU_ITEM.equals(item.getText())) {
                    int oldRowCount = FileUploadClient.this.tableModel.getRowCount();
                    FileUploadClient.this.tableModel.removeRows(table.getSelectedRows());
                    FileUploadClient.this.tableModel.fireTableRowsDeleted(0, oldRowCount);
                }
            }
        });
        menu.add(menuItem);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (table.getSelectedRows().length > 0 && menu.isEnabled() && e.isPopupTrigger()) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return menu;
    }

    private DefaultTableColumnModel createTableColumnModel() {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn(0, 150);
        column.setHeaderValue("File");
        columnModel.addColumn(column);
        column = new TableColumn(1, 50);
        column.setHeaderValue("Status");
        column.setCellRenderer(new UploadTableCellRenderer());
        columnModel.addColumn(column);
        return columnModel;
    }

    private void chooseAndAddFile() {
        File file = FileChooserUtils.tryChooseFile(this.getWindowFrame(), this.workingDirectory, false);
        if (file != null) {
            this.workingDirectory = file.getParentFile();
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.getWindowFrame(), "Problem canonicalizing file:\n" + file.getAbsolutePath());
                return;
            }
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this.getWindowFrame(), "File does not exists:\n" + file.getAbsolutePath());
                return;
            }
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(this.getWindowFrame(), "Can't upload whole directories.");
                return;
            }
            if (this.tableModel.alreadyAdded(file)) {
                JOptionPane.showMessageDialog(this.getWindowFrame(), "File already added:\n" + file.getAbsolutePath());
                return;
            }
            this.tableModel.addFile(file);
        }
    }

    private void setEnableStateOfButtons(boolean enable) {
        if (this.addButton != null) {
            this.addButton.setEnabled(enable);
        }
        if (this.encryptButton != null) {
            this.encryptButton.setEnabled(enable);
        }
        if (this.uploadButton != null) {
            this.uploadButton.setEnabled(enable);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(!enable);
        }
        if (this.popupMenu != null) {
            this.popupMenu.setEnabled(enable);
        }
    }

    @Override
    protected boolean cancel() {
        if (!this.uploader.isInProgress()) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this.getWindowFrame(), "Do you really want to cancel uploading?");
        if (answer == 0) {
            this.uploader.cancel();
            return true;
        }
        return false;
    }

    @Override
    protected final String getTitle() {
        return TITLE;
    }

    private List<FileWithOverrideName> encryptFilesIfRequested(List<FileWithOverrideName> files) {
        if (this.doEncrypt()) {
            ArrayList<FileWithOverrideName> encryptedFiles = new ArrayList<FileWithOverrideName>(files.size());
            for (FileWithOverrideName file : files) {
                try {
                    FileItem fileItemOrNull = this.tableModel.fireChanged(file.getOriginalFile(), FileItemStatus.ENCRYPTING);
                    if (file.getEncryptedFile().exists()) {
                        int answer = JOptionPane.showConfirmDialog(this.getWindowFrame(), "Output file '" + file.getEncryptedFile().getAbsolutePath() + "' already exists. " + "Overwrite?", "File exists", 0);
                        if (answer == 0) {
                            if (!file.getEncryptedFile().delete()) {
                                FileUploadClient.notifyUserOfThrowable(this.getWindowFrame(), file.getOriginalFile().getPath(), "Encrypting", new IOException("File '" + file.getEncryptedFile() + "' could not be deleted."), null);
                                this.tableModel.fireChanged(file.getOriginalFile(), FileItemStatus.ABORTED);
                                continue;
                            }
                        } else {
                            this.tableModel.fireChanged(file.getOriginalFile(), FileItemStatus.ABORTED);
                            continue;
                        }
                    }
                    File encryptedFile = OpenPGPSymmetricKeyEncryption.encrypt(file.getOriginalFile(), file.getEncryptedFile(), this.passphrase, false);
                    if (fileItemOrNull != null) {
                        fileItemOrNull.setUploadedFile(encryptedFile);
                    }
                    encryptedFiles.add(new FileWithOverrideName(encryptedFile, file.tryGetOverrideName()));
                    if (!this.doDeleteEncryptedFilesAfterSuccessfulUpload()) continue;
                    this.encryptedFilesToBeDeleted.add(encryptedFile);
                }
                catch (Throwable th) {
                    FileUploadClient.notifyUserOfThrowable(this.getWindowFrame(), file.getOriginalFile().getPath(), "Encrypting", th, null);
                    this.tableModel.fireChanged(file.getOriginalFile(), FileItemStatus.ABORTED);
                    break;
                }
            }
            return encryptedFiles;
        }
        return files;
    }

    private boolean doDeleteEncryptedFilesAfterSuccessfulUpload() {
        return this.doEncrypt() && this.deleteEncryptedFilesAfterSuccessfulUpload;
    }

    private boolean doEncrypt() {
        return StringUtils.isNotEmpty((String)this.passphrase);
    }

    @Override
    protected File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    protected boolean isDeleteEncryptedFile() {
        return this.deleteEncryptedFilesAfterSuccessfulUpload;
    }
}

