/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.gui.ClipboardUtils;
import ch.systemsx.cisd.cifex.rpc.client.gui.SpringLayoutUtilities;
import ch.systemsx.cisd.common.security.PasswordGenerator;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class PassphraseDialog {
    private static final int PASSPHRASE_FIELD_LENGTH = 40;

    public static PassphraseAndFileDeletion tryGetPassphraseForEncrypt(Frame parentComponent, String oldPassphase, boolean deleteEncrypted, PasswordGenerator generatorOrNull, String title, String message) {
        return PassphraseDialog.tryGetPassphrase(parentComponent, generatorOrNull, title, message, oldPassphase, true, true, deleteEncrypted);
    }

    public static PassphraseAndFileDeletion tryGetPassphraseForDecrypt(Frame parentComponent, String oldPassphase, boolean deleteEncrypted, String title, String message) {
        return PassphraseDialog.tryGetPassphrase(parentComponent, null, title, message, oldPassphase, false, true, deleteEncrypted);
    }

    public static String tryGetPassphraseForDecryptRetry(Frame parentComponent, String title, String message) {
        PassphraseAndFileDeletion resultOrNull = PassphraseDialog.tryGetPassphrase(parentComponent, null, title, message, null, false, false, null);
        return resultOrNull != null ? resultOrNull.getPassphrase() : null;
    }

    public static PassphraseAndFileDeletion tryGetPassphrase(final Frame parentComponent, PasswordGenerator generatorOrNull, String title, String message, String oldPassphraseOrNull, boolean encrypt, final boolean allowEmptyPassphrase, Boolean deleteEncryptedOrNull) {
        JCheckBox deleteEncryptedBoxOrNull;
        JPanel checkBoxPanelOrNull;
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final JDialog dialog = new JDialog(parentComponent, title, true);
        JPanel panel = new JPanel(new SpringLayout());
        dialog.getContentPane().add(panel);
        JLabel messageLabel = new JLabel("<html><center>" + message + "</center></html>", 0);
        JPanel passphrasePanel = new JPanel();
        JLabel passphraseLabel = new JLabel("Passphrase");
        final JPasswordField passphraseField = new JPasswordField(40);
        passphraseField.setText(oldPassphraseOrNull);
        passphrasePanel.add(passphraseLabel);
        passphrasePanel.add(passphraseField);
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancelled.set(true);
                dialog.dispose();
            }
        });
        if (deleteEncryptedOrNull != null) {
            checkBoxPanelOrNull = new JPanel();
            checkBoxPanelOrNull.setLayout(new BoxLayout(checkBoxPanelOrNull, 2));
            checkBoxPanelOrNull.add(Box.createHorizontalGlue());
            deleteEncryptedBoxOrNull = new JCheckBox("Delete Encrypted Files", (boolean)deleteEncryptedOrNull);
            deleteEncryptedBoxOrNull.setToolTipText("Delete encrypted file(s) from local harddisk after successful " + (encrypt ? "upload" : "decryption"));
            checkBoxPanelOrNull.add(deleteEncryptedBoxOrNull);
        } else {
            checkBoxPanelOrNull = null;
            deleteEncryptedBoxOrNull = null;
        }
        if (encrypt) {
            passphrasePanel.setLayout(new SpringLayout());
            JLabel passphraseLabelRepeated = new JLabel("Passphrase (repeat)");
            final JPasswordField passphraseRepeatedField = new JPasswordField(40);
            passphraseRepeatedField.setText(oldPassphraseOrNull);
            passphrasePanel.add(passphraseLabelRepeated);
            passphrasePanel.add(passphraseRepeatedField);
            SpringLayoutUtilities.makeCompactGrid(passphrasePanel, 2, 2, 5, 5, 5, 5);
            passphraseField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PassphraseDialog.canCloseRegularly(passphraseField, allowEmptyPassphrase)) {
                        passphraseRepeatedField.requestFocus();
                    }
                }
            });
            passphraseRepeatedField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PassphraseDialog.canCloseRegularly(parentComponent, passphraseField, passphraseRepeatedField, allowEmptyPassphrase)) {
                        dialog.dispose();
                    }
                }
            });
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PassphraseDialog.canCloseRegularly(parentComponent, passphraseField, passphraseRepeatedField, allowEmptyPassphrase)) {
                        dialog.dispose();
                    }
                }
            });
            okButton.setEnabled(PassphraseDialog.canCloseRegularly(passphraseField, allowEmptyPassphrase));
            JButton clearPassphraseButton = new JButton("Clear");
            clearPassphraseButton.setToolTipText("Clear the currently entered passphrase");
            buttonPanel.add(clearPassphraseButton);
            clearPassphraseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    passphraseField.setText("");
                    passphraseRepeatedField.setText("");
                }
            });
            if (generatorOrNull != null) {
                JButton generateStrongPassphraseButton = new JButton("Generate Strong");
                generateStrongPassphraseButton.setToolTipText("Create an extra strong (random) phassphrase");
                buttonPanel.add(generateStrongPassphraseButton);
                generateStrongPassphraseButton.addActionListener(PassphraseDialog.createStrongPassphraseGenerator(passphraseField, passphraseRepeatedField, parentComponent, generatorOrNull));
                JButton generateMemorablePassphraseButton = new JButton("Generate Memorable");
                generateMemorablePassphraseButton.setToolTipText("Create a memorable passphase");
                buttonPanel.add(generateMemorablePassphraseButton);
                generateMemorablePassphraseButton.addActionListener(PassphraseDialog.createMemorablePassphraseGenerator(passphraseField, passphraseRepeatedField, parentComponent, generatorOrNull));
            }
        } else {
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PassphraseDialog.canCloseRegularly(passphraseField, allowEmptyPassphrase)) {
                        dialog.dispose();
                    }
                }
            });
            okButton.setEnabled(PassphraseDialog.canCloseRegularly(passphraseField, allowEmptyPassphrase));
            passphraseField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PassphraseDialog.canCloseRegularly(passphraseField, allowEmptyPassphrase)) {
                        dialog.dispose();
                    }
                }
            });
            JButton passphrasePasteFromClipboardButton = new JButton("Paste");
            passphrasePasteFromClipboardButton.setToolTipText("Paste Passphrase from Clipboard");
            buttonPanel.add(passphrasePasteFromClipboardButton);
            passphrasePasteFromClipboardButton.addActionListener(PassphraseDialog.createPassphrasePaster(passphraseField, parentComponent));
        }
        buttonPanel.add(cancelButton);
        buttonPanel.add(okButton);
        if (!allowEmptyPassphrase) {
            passphraseField.getDocument().addDocumentListener(PassphraseDialog.createOKButtonStateUpdater(okButton, passphraseField));
        }
        int numberOfItems = 3;
        panel.add(messageLabel);
        panel.add(passphrasePanel);
        if (checkBoxPanelOrNull != null) {
            panel.add(checkBoxPanelOrNull);
            ++numberOfItems;
        }
        panel.add(buttonPanel);
        SpringLayoutUtilities.makeCompactGrid(panel, numberOfItems, 1, 5, 5, 5, 5);
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancelled.set(true);
                dialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        dialog.addWindowListener(PassphraseDialog.createCloseWindowCancellingListener(cancelled));
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(parentComponent);
        dialog.pack();
        dialog.setVisible(true);
        if (cancelled.get()) {
            return null;
        }
        return new PassphraseAndFileDeletion(new String(passphraseField.getPassword()), deleteEncryptedBoxOrNull != null ? Boolean.valueOf(deleteEncryptedBoxOrNull.isSelected()) : null);
    }

    private static ActionListener createStrongPassphraseGenerator(final JPasswordField passphraseField, final JPasswordField passphraseRepeatedField, final Frame parentComponent, final PasswordGenerator generatorOrNull) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String passphrase = generatorOrNull.generatePassword(40, false);
                passphraseField.setText(passphrase);
                passphraseRepeatedField.setText(passphrase);
                ClipboardUtils.copyToClipboard(passphrase);
                JOptionPane.showMessageDialog(parentComponent, "<html><center>The generated passphrase has been copied to the clipboard.<br><br><em>Make sure you keep it safe or you won't be able to decrypt the file!</em></center></html>", "Your passphrase", 1);
            }
        };
    }

    private static ActionListener createMemorablePassphraseGenerator(final JPasswordField passphraseField, final JPasswordField passphraseRepeatedField, final Frame parentComponent, final PasswordGenerator generatorOrNull) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String passphrase = generatorOrNull.generatePassword(10, true);
                passphraseField.setText(passphrase);
                passphraseRepeatedField.setText(passphrase);
                ClipboardUtils.copyToClipboard(passphrase);
                JOptionPane.showMessageDialog(parentComponent, "<html><center>The generated password is:<br><br><code><font size=+3>" + passphrase + "</font></code><br><br>(It has been copied to " + "the clipboard.)</center></html>", "Your password", 1);
            }
        };
    }

    private static ActionListener createPassphrasePaster(final JPasswordField passphraseField, final Frame parentComponent) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String passphraseOrNull = ClipboardUtils.tryPasteClipboard();
                    if (passphraseOrNull == null) {
                        JOptionPane.showMessageDialog(parentComponent, "No content in the clipboard.");
                    } else {
                        passphraseField.setText(passphraseOrNull);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(parentComponent, "Error accessing clipboard.", "", 0);
                }
            }
        };
    }

    private static DocumentListener createOKButtonStateUpdater(final JButton okButton, final JPasswordField passphraseField) {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateOKButtonState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateOKButtonState();
            }

            void updateOKButtonState() {
                okButton.setEnabled(passphraseField.getPassword().length > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    private static WindowListener createCloseWindowCancellingListener(final AtomicBoolean cancelled) {
        return new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                cancelled.set(true);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        };
    }

    private static boolean canCloseRegularly(JPasswordField passphraseField, boolean allowEmptyPassphrase) {
        return allowEmptyPassphrase || passphraseField.getPassword().length > 0;
    }

    private static boolean canCloseRegularly(Frame parentComponent, JPasswordField passphraseField, JPasswordField passphraseRepeatedField, boolean allowEmptyPassphrase) {
        char[] passphraseRepeat;
        char[] passphrase = passphraseField.getPassword();
        if (!Arrays.equals(passphrase, passphraseRepeat = passphraseRepeatedField.getPassword())) {
            JOptionPane.showMessageDialog(parentComponent, "You entered different passphrases, please check your input.", "Passphrase mismatch", 0);
            return false;
        }
        return allowEmptyPassphrase || passphrase.length > 0;
    }

    public static final class PassphraseAndFileDeletion {
        private final String passphrase;
        private final Boolean deleteEncryptedOrNull;

        private PassphraseAndFileDeletion(String passphrase, Boolean deleteEncryptedOrNull) {
            this.passphrase = passphrase;
            this.deleteEncryptedOrNull = deleteEncryptedOrNull;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public Boolean tryGetDeleteEncrypted() {
            return this.deleteEncryptedOrNull;
        }
    }
}

