/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.io;

import ch.systemsx.cisd.cifex.rpc.io.IntConversionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyUtils {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    public static int copyAndReturnChecksum(InputStream input, OutputStream output, long size, long startPos) throws IOException {
        byte[] buffer = new byte[16384];
        int n = 0;
        long count = startPos;
        int bytesToRead = (int)Math.min(16384L, size);
        while (-1 != (n = input.read(buffer, 0, bytesToRead)) && count < size) {
            output.write(buffer, 0, n);
            bytesToRead = (int)Math.min(16384L, size - (count += (long)n));
        }
        n = input.read(buffer, 0, 4);
        if (n != 4) {
            throw new IOException("Error reading checksum.");
        }
        return IntConversionUtils.bytesToInt(buffer);
    }
}

