/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class UrlServletForwardingController
extends AbstractController {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, UrlServletForwardingController.class);

    private final String getServletName(HttpServletRequest request) {
        return (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestDispatcher rd;
        String servletName;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Forwarding request '" + request.getRequestURL() + "'."));
        }
        if ((servletName = this.getServletName(request)).charAt(0) == '/') {
            servletName = servletName.substring(1);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Servlet name is '" + servletName + "'."));
        }
        if ((rd = this.getServletContext().getNamedDispatcher(servletName)) == null) {
            throw new ServletException(String.format("No servlet with name '%s' defined in web.xml", servletName));
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Forwarding to servlet [%s] in '%s'.", servletName, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
        return null;
    }
}

