/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.server.business.AbstractEMailBuilder;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.mail.IMailClient;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class EMailBuilderForNewUser
extends AbstractEMailBuilder {
    private static final String NEW_ACCOUNT_EMAIL_SUBJECT_LINE = "new-account-email-subject";
    private static final String NEW_ACCOUNT_EMAIL_TEMPLATE_FILE_NAME = "etc/new-account-email.template";
    private final UserDTO newUser;

    public EMailBuilderForNewUser(IMailClient mailClient, UserDTO registrator, UserDTO newUser) {
        super(mailClient, registrator, newUser.getEmail());
        this.newUser = newUser;
        this.setFullName(newUser.getUserFullName());
    }

    @Override
    protected String createContent() {
        assert (this.password != null) : "Missing password.";
        return this.createContent(NEW_ACCOUNT_EMAIL_TEMPLATE_FILE_NAME);
    }

    @Override
    protected String createSubject() {
        return StringUtils.capitalize((String)((String)this.emailDict.get(NEW_ACCOUNT_EMAIL_SUBJECT_LINE)));
    }

    @Override
    protected String getUserCode() {
        return this.newUser.getUserCode();
    }

    @Override
    protected Date tryGetExpirationDate() {
        return this.newUser.getExpirationDate();
    }

    @Override
    protected void addToDict(Properties emailProps, DateFormat dateFormat) {
        if (this.newUser.isAdmin()) {
            this.emailDict.put("account-type", emailProps.getProperty("account-type-admin"));
            this.emailDict.put("account-type2", emailProps.getProperty("account-type-admin2"));
        } else if (this.newUser.isPermanent()) {
            this.emailDict.put("account-type", emailProps.getProperty("account-type-regular"));
            this.emailDict.put("account-type2", emailProps.getProperty("account-type-regular2"));
        } else {
            this.emailDict.put("account-type", emailProps.getProperty("account-type-temp"));
            this.emailDict.put("account-type2", emailProps.getProperty("account-type-temp2"));
        }
    }
}

