/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogAnnotation;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.util.Collection;
import java.util.List;

public interface IUserManager {
    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public boolean isDatabaseEmpty();

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public UserDTO getUser(long var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public UserDTO tryFindUserByCode(String var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public List<UserDTO> findUserByEmail(String var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public List<UserDTO> listUsers();

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public List<UserDTO> listUsersRegisteredBy(long var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public void refreshQuotaInformation(UserDTO var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public boolean hasUserFilesForDownload(UserDTO var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public UserDTO createUser(UserDTO var1, UserDTO var2) throws UserFailureException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public UserDTO createUserAndSendEmail(UserDTO var1, String var2, UserDTO var3, String var4, String var5) throws UserFailureException, EnvironmentFailureException;

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.DEBUG)
    public void deleteExpiredUsers(IUserActionLog var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public void deleteUser(long var1, UserDTO var3, IUserActionLog var4) throws IllegalArgumentException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public UserDTO updateUser(UserDTO var1, UserDTO var2, Password var3, UserDTO var4, IUserActionLog var5) throws UserFailureException, IllegalArgumentException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public UserDTO updateUser(UserDTO var1, Password var2, UserDTO var3, IUserActionLog var4) throws UserFailureException, IllegalArgumentException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public void changeUserCode(String var1, String var2) throws UserFailureException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public List<UserDTO> listUsersFileSharedWith(long var1) throws UserFailureException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public Collection<UserDTO> getUsers(List<String> var1, List<String> var2, IUserActionLog var3);
}

