/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.common;

import ch.systemsx.cisd.common.security.PasswordHasher;
import ch.systemsx.cisd.common.string.StringUtilities;
import org.apache.commons.lang.StringUtils;

public final class Password {
    private final String plainPasswordOrNull;

    public static boolean equals(Password password1, Password password2) {
        if (Password.isEmpty(password1)) {
            return Password.isEmpty(password2);
        }
        return password1.equals(password2);
    }

    public static boolean isEmpty(Password password) {
        return password == null || StringUtils.isBlank((String)password.plainPasswordOrNull);
    }

    public Password(String plainPasswordOrNull) {
        this.plainPasswordOrNull = plainPasswordOrNull;
    }

    public String tryGetPlain() {
        return this.plainPasswordOrNull;
    }

    public String createPasswordHash() throws IllegalStateException {
        if (Password.isEmpty(this)) {
            throw new IllegalStateException("Cannot compute password hash of null password.");
        }
        return PasswordHasher.computeSaltedHash(this.plainPasswordOrNull);
    }

    public boolean matches(String passwordHash) {
        if (Password.isEmpty(this) || StringUtils.isBlank((String)passwordHash)) {
            return false;
        }
        if (PasswordHasher.isPasswordCorrect(this.plainPasswordOrNull, passwordHash)) {
            return true;
        }
        return StringUtils.equals((String)StringUtilities.computeMD5Hash(this.plainPasswordOrNull), (String)passwordHash);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Password)) {
            return false;
        }
        Password that = (Password)obj;
        if (this.plainPasswordOrNull == null) {
            return that.plainPasswordOrNull == null;
        }
        return this.plainPasswordOrNull.equals(that.plainPasswordOrNull);
    }

    public int hashCode() {
        if (this.plainPasswordOrNull == null) {
            return 23;
        }
        return this.plainPasswordOrNull.hashCode();
    }
}

