/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.util;

import ch.systemsx.cisd.cifex.shared.basic.dto.FileUploadFeedback;
import ch.systemsx.cisd.cifex.shared.basic.dto.Message;
import java.io.Serializable;

public final class FileUploadFeedbackProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FileUploadFeedback feedback;
    private Message message;
    private boolean fileUploadIsProgressing;

    public synchronized void set(FileUploadFeedback feedback) {
        assert (feedback != null);
        assert (feedback.getMessage() == null);
        assert (!feedback.isFinished());
        this.fileUploadIsProgressing = true;
        this.message = null;
        this.feedback = feedback;
        this.notify();
    }

    public synchronized void setFileUploadFinished() {
        this.fileUploadIsProgressing = false;
        this.feedback = null;
        this.notifyAll();
    }

    public synchronized void setMessage(Message message) {
        assert (message != null);
        this.message = message;
        this.setFileUploadFinished();
    }

    public synchronized FileUploadFeedback take() throws InterruptedException {
        FileUploadFeedback feedbackOrNull = this.tryGet();
        if (feedbackOrNull == null) {
            this.wait();
            feedbackOrNull = this.tryGet();
        }
        return feedbackOrNull;
    }

    private FileUploadFeedback tryGet() {
        if (!this.fileUploadIsProgressing) {
            FileUploadFeedback fakeFeedback = new FileUploadFeedback();
            fakeFeedback.setFinished(true);
            if (this.message != null) {
                fakeFeedback.setMessage(this.message);
            }
            return fakeFeedback;
        }
        FileUploadFeedback result = this.feedback;
        this.feedback = null;
        return result;
    }
}

