/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.util;

import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.FilenameUtils;

public class FilenameUtilities {
    private static final int EXTENSION_SEPARATOR_LENGTH = FilenameUtils.EXTENSION_SEPARATOR_STR.length();
    private static final MimetypesFileTypeMap fileTypeToMIMETypeMap = new MimetypesFileTypeMap();

    static {
        fileTypeToMIMETypeMap.addMimeTypes("application/pdf pdf PDF");
    }

    private FilenameUtilities() {
    }

    public static String getMimeType(String filename) {
        return fileTypeToMIMETypeMap.getContentType(filename);
    }

    public static String ensureMaximumSize(String filename, int maximumLength) {
        if (filename.length() <= maximumLength) {
            return filename;
        }
        String extension = FilenameUtils.getExtension((String)filename);
        int extensionLength = extension.length();
        int maxLengthWithoutExtension = maximumLength - extensionLength - EXTENSION_SEPARATOR_LENGTH;
        if (maxLengthWithoutExtension < 1) {
            return filename.substring(0, maximumLength);
        }
        String filenameWithoutExtension = FilenameUtils.removeExtension((String)filename);
        return String.valueOf(filenameWithoutExtension.substring(0, maxLengthWithoutExtension)) + FilenameUtils.EXTENSION_SEPARATOR_STR + extension;
    }
}

